#include <QCoreApplication>
#include "RadomForestSAC/RamdomForestCalculate.h"
#include "spdlog/spdlog.h"
#include "spdlog/sinks/base_sink.h"
//#include "spdlog/sinks/rotating_file_sink.h"
#include "spdlog/sinks/daily_file_sink.h"
#include <QDir>
#include "MonitorLogfile.h"

void initSpdlog()
{
    try
    {

        QString path = qApp->applicationDirPath() + "/log";
        QDir dir(path);
        if (!dir.exists())
            dir.mkpath(path); //只创建一级子目录，即必须保证上级目录存在

        QString path1 = path;
        path += "/SigerCalculation.txt";

        spdlog::daily_logger_mt("logger", path.toStdString(), 2, 30);

        spdlog::set_pattern("[%Y-%m-%d %H:%M:%S.%e][thread %t][%l][%!,%#] : %v");
        spdlog::get("logger")->flush_on(spdlog::level::trace);
        spdlog::get("logger")->set_level(spdlog::level::trace);

        SPDLOG_LOGGER_DEBUG(spdlog::get("logger"), "initSpdlog DEBUG!");

    }
    catch (const spdlog::spdlog_ex& ex)
    {

    }

}

int main(int argc, char *argv[])
{
    QCoreApplication a(argc, argv);

    initSpdlog();
    auto daily_logger=spdlog::get("logger");

    qDebug() << "daily_logger is null? " << (daily_logger == nullptr);

    MonitorLogfile m_Logfile;


    RamdomForestCalculate RandomCaculate;

    //qRegisterMetaType<Dc_SacData>("Dc_SacData");
   // do_test1();
//    TcpServerManager manager;

//    // 连接 dc 信号和槽函数
//    QObject::connect(&manager, &TcpServerManager::getdc_sacdata,
//                     [=](const Dc_SacData &sac_data) {
//        qDebug() << "收到 dc_sacdata 信号";
//        qDebug() << "Source:" << sac_data.source;
//        qDebug() << "SacFile:" << sac_data.sacFile;
//        qDebug() << "Target:" << sac_data.target;
//        //do_test1(sac_data);  // 现在可以识别了
//    });

    return a.exec();
}
