#include "MTcpClient.h"

MTcpClient::MTcpClient(QObject *parent)
    : QObject{parent}
{

}

bool MTcpClient::connectHost(const QString &id, const QString &ip, quint16 port)
{
    if(m_connections.contains(id))
        return false;

    MTcpSocketControl* control = new MTcpSocketControl;
    connect(control, &MTcpSocketControl::recvData, [this, id](const QString& data){
        emit this->recvData(id, data);
    });
    emit control->connectSocket(ip, port);

    QSharedPointer<MTcpSocketControl> p(control);
    m_connections[id] = p;

    return true;
}

void MTcpClient::sendData(const QString &data, const QString &id)
{
    if(m_connections.contains(id) == false)
        return;
    emit m_connections.value(id)->sendData(data);
}

