#ifndef SIGNAL_FEATURES_H
#define SIGNAL_FEATURES_H

#include <vector>
#include <algorithm>
#include <cstdio>
#include <QString>
#include <cmath>    // 对于C++11及以上版

struct SignalFeatures
{
    union
    {
        struct
        {
            float Envelope_RMS;
            float Envelope_Peak;
            float Envelope_Mean;
            float Envelope_Std;
            float Envelope_Kurtosis;
            float Envelope_CrestFactor;
            float Envelope_ClearanceFactor;
            float Envelope_ImpulseFactor;
            float Envelope_SpectralCentroid;
            float Envelope_TotalEnergy;
        };
        
        float data[10];  // 保证内存连续访问
    };

    void clear() {
        for (int i = 0; i < 10; ++i) {
            data[i] = 0.0f;
        }
    }

    // 高效的toVector - 零拷贝构造
    std::vector<float> toVector() const {
        return std::vector<float>(data, data + 10);
    }

    int print()
    {
        int ret = 0;
        char buf[1024] = {0};
        ret = snprintf(buf, sizeof(buf)-1,
	         "\n=== Signal Feature Analysis Results ===\n"
                 "Envelope_RMS: %f\n"
                 "Envelope_Peak: %f\n"
                 "Envelope_Mean: %f\n"
                 "Envelope_Std: %f\n"
                 "Envelope_Kurtosis: %f\n"
                 "Envelope_CrestFactor: %f\n"
                 "Envelope_ClearanceFactor: %f\n"
                 "Envelope_ImpulseFactor: %f\n"
                 "Envelope_SpectralCentroid: %f\n"
                 "Envelope_TotalEnergy: %f\n",
                 Envelope_RMS, Envelope_Peak, Envelope_Mean, Envelope_Std, Envelope_Kurtosis,
                 Envelope_CrestFactor, Envelope_ClearanceFactor, Envelope_ImpulseFactor,
                 Envelope_SpectralCentroid, Envelope_TotalEnergy);
        buf[ret] = 0;
        printf("%s", buf);
	return 0;
    }

    void fill(QString &result)
    {
        result = QString("%1,%2,%3,%4,%5,%6,%7,%8,%9,%10")
                .arg(Envelope_RMS).arg(Envelope_Peak).arg(Envelope_Mean).arg(Envelope_Std).arg(Envelope_Kurtosis)
                .arg(Envelope_CrestFactor).arg(Envelope_ClearanceFactor).arg(Envelope_ImpulseFactor)
                .arg(Envelope_SpectralCentroid).arg(Envelope_TotalEnergy);
    }

    bool isValid()
    {
        bool  isAllZero = true;
        for (int i = 0; i < 10; ++i)
        {
            if (!std::isfinite(data[i]) || std::abs(data[i]) > 1e10f)
                return false;

            if (std::abs(data[i]) > 1e-10f)
                isAllZero = false;
        }

        return (!isAllZero);
    }
};

#endif // SIGNAL_FEATURES_H
