#include "MTcpSocketControl.h"

MTcpSocketControl::MTcpSocketControl(MsgHandle handle, QObject *parent)
    : QObject{parent}
{
    qRegisterMetaType<qintptr>("qintptr");
    m_socket = new MTcpSocket;
    m_socket->setMsgHandle(handle);
    m_thread = new QThread;

    connect(this, &MTcpSocketControl::sendData, m_socket, &MTcpSocket::sendData);
    connect(this, &MTcpSocketControl::connectSocket, m_socket, &MTcpSocket::connectSocket);
    connect(this, &MTcpSocketControl::initSocket, m_socket, &MTcpSocket::initSocket);
    connect(m_socket, &MTcpSocket::recvData, this, &MTcpSocketControl::recvData);
    connect(m_socket, &MTcpSocket::sendFail, this, &MTcpSocketControl::sendFail);

    m_socket->moveToThread(m_thread);
    m_thread->start();
}

MTcpSocketControl::~MTcpSocketControl()
{
    m_thread->quit();
    m_thread->wait();
    delete m_socket;
    delete m_thread;
}
