#ifndef RAMDOMFORESTCALCULATE_H
#define RAMDOMFORESTCALCULATE_H

#include <QObject>
#include <QString>
#include "common.h"
#include "SignalFeatures.h"
#include "FeatureExtractor.h"
#include "RandomForestClassifier.h"
#include "tcp/TcpServerManager.h"
#include "tcp/TcpClient.h"
#include "./dbtool/dbFunc.h"
#include "./RadomForestSAC/VibrationDataReader.h"
#include <QDateTime>
#include <QSqlDatabase>
#include <QSqlQuery>
#include <QSqlError>
#include <QTimer>


// 如果 Dc_SacData 是结构体/类，需要注册元类型
Q_DECLARE_METATYPE(Dc_SacData)
using namespace std;
// 定义振动数据结构体
struct SACRecord {
    QString startTime;
    QString endTime;
    QString target;
    int label;
    QString x;
    QString y;
    QString z;
};

//定义 给流式发送信息结构体
struct StreamInfo
{
    int alarmtype;
    QString target;
    QString startIds;
    QString endIds;

    StreamInfo(int a = 0, const QString& t = "", const QString& s = "", const QString& e = "")
        : alarmtype(a), target(t), startIds(s), endIds(e)
    {

    }
};



class RamdomForestCalculate : public QObject
{
    Q_OBJECT

public:
    explicit RamdomForestCalculate(QObject *parent = nullptr);

    //1.

    //2.发送给流式的消息
    void SendStreamAlarminfo(const StreamInfo& alarmInfo);

    //3.查询函数
    QList<SACRecord> queryRecordsByLabel(const QString& dbFileName, int targetLabel);

    //4.接受DC消息，保存振动数据
    int Save_SACDATA(const Dc_SacData& sacdata);

    //5.判断报警
    int judge_alarm();

    //6.解析查询到的振动值
    void DealRecord(const QList<SACRecord> &record,std::vector<std::vector<float>>& result1,std::vector<int> &result2);

    //7.重新训练
    void Retrain();

signals:
    void nameChanged();
    void somethingDone(const QString &result);

private:
    //QString m_name;
    DBFunc *dbFunc;
    TcpServerManager *m_tcpServerManager;

    RandomForestClassifier* Classifier;
};


#endif // RAMDOMFORESTCALCULATE_H
