#ifndef TCPCLIENT_H
#define TCPCLIENT_H

#include <QTcpSocket>
#include <QObject>
#include <QJsonObject>
#include <QJsonDocument>

#define STREAM_MESSAGE "random_alarm"
#define STREAM_PORT  5999

class TcpClient : public QObject
{
    Q_OBJECT

public:
    explicit TcpClient(QObject *parent = nullptr);
    ~TcpClient();

    void connectToServer(const QString &host = "127.0.0.1", quint16 port = 8888);
    void sendMessage(const QJsonObject &message);
    void disconnectFromServer();

signals:
    void connected();
    void disconnected();
    void messageReceived(const QJsonObject &message);
    void errorOccurred(const QString &error);

private slots:
    void onConnected();
    void onDisconnected();
    void onReadyRead();
    void onErrorOccurred(QAbstractSocket::SocketError error);

private:
    QTcpSocket *m_socket;
    QByteArray m_buffer;
};

#endif // TCPCLIENT_H
