#ifndef VIBRATIONDATAREADER_H
#define VIBRATIONDATAREADER_H

#include <QObject>
#include <QVector>
#include <QFile>

// 振动数据结构体
struct VibrationData {
    float x;
    float y;
    float z;
};

class VibrationDataReader : public QObject
{
    Q_OBJECT

public:
    explicit VibrationDataReader(QObject *parent = nullptr);

    // 读取文件
    bool readFile(const QString &filename);

    // 原始字节读取方法
    bool readFileRaw(const QString &filename);

    //转化，供随机森林计算特征值
    std::array<std::vector<float>, 3> convertToRawFormat() const;

    // 获取数据
    QVector<VibrationData> getVibrationData() const { return m_vibrationData; }

    // 获取数据组数
    int getDataCount() const { return m_vibrationData.size(); }

    // 获取数据块数量（每240字节为一个数据块）
    int getDataBlocks() const { return m_dataBlocks; }

    // 获取文件总字节数
    qint64 getTotalBytes() const { return m_totalBytes; }

    // 打印数据信息
    void printDataInfo() const;

private:
    QVector<VibrationData> m_vibrationData;
    int m_dataBlocks;  // 数据块数量
    qint64 m_totalBytes; // 文件总字节数
};

#endif // VIBRATIONDATAREADER_H
