#ifndef DBFUNC_H
#define DBFUNC_H

#include <QObject>
#include <QThread>
#include "blockingconcurrentqueue.h"

#define SIGER_EXIT  "siger_exit"

class DBFunc : public QObject
{
    Q_OBJECT

public:
    // 构造函数
    explicit DBFunc(QObject* parent = nullptr);
    ~DBFunc();

    // 启动数据库线程
    void startDBThread(const QString& sensorDataTableName = "sensor_data");

    // 停止数据库线程
    void stopDBThread();

    // 添加数据到处理队列
    void addDataToQueue(const std::string& data);

    // 检查线程是否运行
    bool isRunning() const;

private:
    void DBThreadFun(QString sensorDataTableName);

private:
    int m_sensor_dataCountDB = 0;
    moodycamel::BlockingConcurrentQueue<std::string> m_blockQueue_DB;
    QThread* m_dbThread = nullptr;
    bool m_stopFlag = false;
    QString m_currentTableName;
};

#endif // DBFUNC_H
