#ifndef MTCPSOCKET_H
#define MTCPSOCKET_H

#include <QObject>
#include <QTcpSocket>

typedef std::function<QString(QString&, const QString&)> MsgHandle;
Q_DECLARE_METATYPE(MsgHandle);

class MTcpSocket : public QObject {
    Q_OBJECT
public:
    explicit MTcpSocket(QObject* parent = nullptr);
    ~MTcpSocket();
    void setMsgHandle(MsgHandle handle);
    void sendData(const QString& data);
    void connectSocket(const QString& ip, quint16 port);
    void initSocket(qintptr handle);
signals:
    void recvData(const QString& data);
    void sendFail();
private slots:
    void readData();

private:
    void createSocket(QTcpSocket* socket);
    void releaseSocket();
    QTcpSocket* m_socket = nullptr;
    bool m_is_server = false;
    QString m_ip;
    quint16 m_port = -1;
    qintptr m_handle = -1;
    QString m_str{};
    const QString m_head = "#$$#";
    MsgHandle m_msg_handle = nullptr;
};

#endif // MTCPSOCKET_H
