QT -= gui
QT += core network sql

CONFIG += c++11 console
CONFIG -= app_bundle

DEFINES += SPDLOG_ACTIVE_LEVEL=SPDLOG_LEVEL_DEBUG

# The following define makes your compiler emit warnings if you use
# any Qt feature that has been marked deprecated (the exact warnings
# depend on your compiler). Please consult the documentation of the
# deprecated API in order to know how to port your code away from it.
DEFINES += QT_DEPRECATED_WARNINGS

include($$PWD/tcp/tcp.pri)

# You can also make your code fail to compile if it uses deprecated APIs.
# In order to do so, uncomment the following line.
# You can also select to disable deprecated APIs only up to a certain version of Qt.
#DEFINES += QT_DISABLE_DEPRECATED_BEFORE=0x060000    # disables all the APIs deprecated before Qt 6.0.0

SOURCES += \
        MonitorLogfile.cpp \
        RadomForestSAC/FeatureExtractor.cpp \
        RadomForestSAC/RamdomForestCalculate.cpp \
        RadomForestSAC/VibrationDataReader.cpp \
        RadomForestSAC/RandomForestClassifier.cpp \
        dbtool/dbFunc.cpp \
        dbtool/dbmana.cpp \
        main.cpp \
        RadomForestSAC/util.cpp

# Default rules for deployment.
qnx: target.path = /tmp/$${TARGET}/bin
else: unix:!android: target.path = /opt/$${TARGET}/bin
!isEmpty(target.path): INSTALLS += target

HEADERS += \
    MonitorLogfile.h \
    RadomForestSAC/FeatureExtractor.h \
    RadomForestSAC/RamdomForestCalculate.h \
    RadomForestSAC/VibrationDataReader.h \
    RadomForestSAC/RandomForestClassifier.h \
    RadomForestSAC/SignalFeatures.h \
    RadomForestSAC/common.h \
    RadomForestSAC/RamdomForestCalculate.h \
    dbtool/blockingconcurrentqueue.h \
    dbtool/concurrentqueue.h \
    dbtool/dbFunc.h \
    dbtool/dbmana.h \
    fftw3.h \


CONFIG(release) {
    message("GLS release")
    unix {
        contains(QT_ARCH, arm){
            message("ARM architecture detected")
            DESTDIR = $$PWD/package/E3
            LIBS += -L$$PWD/arm
        } else: contains(QT_ARCH, x86_64){
            message("x86_64 architecture detected")
            LIBS += -L$$PWD/x86
        } else {
            message("arm64/ architecture detected")
            DESTDIR = $$PWD/package/E3+
            LIBS += -L$$PWD/arm64
        }
    }
}

# 添加库文件路径
#LIBS += -L$$PWD/x86

# 链接静态库
LIBS += -ldlib
LIBS += -lfftw3f
