#include "TcpServerManager.h"
#include <QJsonDocument>
#include <QJsonObject>
#include <QJsonParseError>
#include <QJsonValue>
#include <QVariant>

TcpServerManager::TcpServerManager(QObject* parent)
    : QObject(parent)
{
    // 设置消息处理函数
    m_server.setMsgHandle([this](const QString& data, const QString& head) {
        return this->handleMessage(data, head);
    });

    // 连接信号槽
    connect(&m_server, &MTcpServer::recvData, this, &TcpServerManager::onDataReceived);

    // 启动服务器
//    if (m_server.startServer(2026)) {
//        qDebug() << "TCP服务器已启动，端口: 2026";
//    } else {
//        qDebug() << "启动服务器失败!";
//    }
}

bool TcpServerManager::startServer(quint16 port)
{
    return m_server.startServer(port);
}

void TcpServerManager::stopServer()
{
    // 如果MTcpServer有关闭方法，可以在这里调用
    // m_server.close();
    qDebug() << "服务器已停止";
}

bool TcpServerManager::isRunning() const
{
    return m_server.isListening();
}

void TcpServerManager::onDataReceived(const QString& clientId, const QString& data)
{
    qDebug() << "来自客户端" << clientId << "的消息:" << data<<" ID"<<clientId;

    // 短连接：收到消息后可以立即回复（可选）
    QString response = "服务器已收到: " + data;
    m_server.sendData(response, clientId);

    // 如果是短连接，服务器会在发送回复后自动断开
    // 因为MTcpSocketControl在sendFail时会清理连接
}

QString TcpServerManager::handleMessage(const QString& data, const QString& head)
{
    qDebug() << "处理消息 - 数据:" << data << "头部:" << head;
    // 解析JSON数据
    QJsonParseError parseError;
    QJsonDocument jsonDoc = QJsonDocument::fromJson(data.toUtf8(), &parseError);

    // 检查解析是否成功
    if (parseError.error != QJsonParseError::NoError) {
        qDebug() << "JSON解析错误:" << parseError.errorString();
        return ""; // 返回空字符串表示解析失败
    }

    // 检查是否是对象
    if (!jsonDoc.isObject()) {
        qDebug() << "JSON数据不是对象格式";
        return "";
    }

    // 获取JSON对象
    QJsonObject jsonObj = jsonDoc.object();

    QString msgsource =jsonObj.value("source").toString();
    // 提取各个字段的值
//    QString source = jsonObj.value("source").toString();
//    QString sacFile = jsonObj.value("sacFile").toString();
//    QString target = jsonObj.value("target").toString();
//    qint64 startIds = jsonObj.value("startIds").toVariant().toLongLong();
//    qint64 endIds = jsonObj.value("endIds").toVariant().toLongLong();
    if(msgsource == DC_MESSAGE)
    {
        Dc_SacData sacdata;
        sacdata.source = jsonObj.value("source").toString();
        sacdata.sacFile = jsonObj.value("sacFile").toString();
        sacdata.target = jsonObj.value("target").toString();
        sacdata.startIds = jsonObj.value("startIds").toString();
        sacdata.endIds = jsonObj.value("endIds").toString();

        emit getdc_sacdata(sacdata);
    }
    else if(msgsource == TMS_MESSAGE)
    {
        emit TMSTrain();
    }

    // 这里实现你的消息解析逻辑
    // 对于短连接，通常直接返回完整数据

//    // 示例1: 如果数据以换行符结束，返回完整消息
//    if (data.contains('\n')) {
//        return data.trimmed();
//    }

//    // 示例2: 如果数据达到特定长度，返回完整消息
//    // if (data.length() >= expectedLength) {
//    //     return data;
//    // }

//    // 示例3: 简单的即时返回（适合短连接）
//    if (!data.isEmpty()) {
//        return data;
//    }

    // 打印解析结果
//    qDebug() << "JSON数据解析成功:";
//    qDebug() << "  source:" << source;
//    qDebug() << "  sacFile:" << sacFile;
//    qDebug() << "  target:" << target;
//    qDebug() << "  startIds:" << startIds;
//    qDebug() << "  endIds:" << endIds;

    return ""; // 返回空字符串表示继续等待数据
}
