#ifndef RAMDOMFORESTCALCULATE_H
#define RAMDOMFORESTCALCULATE_H

#include <QObject>
#include <QString>
#include "common.h"
#include "SignalFeatures.h"
#include "FeatureExtractor.h"
#include "RandomForestClassifier.h"
#include "tcp/TcpServerManager.h"
#include "tcp/TcpClient.h"
#include "./dbtool/dbFunc.h"
#include "./RadomForestSAC/VibrationDataReader.h"
#include <QDateTime>
#include <QSqlDatabase>
#include <QSqlQuery>
#include <QSqlError>
#include <QTimer>

#ifndef SAC_FEATURE_DIM
#define SAC_FEATURE_DIM 10
#endif

// 如果 Dc_SacData 是结构体/类，需要注册元类型
Q_DECLARE_METATYPE(Dc_SacData)
using namespace std;
// 定义振动数据结构体
struct SACRecord {
    QString startTime;
    QString endTime;
    QString target;
    int label;
    QString x;
    QString y;
    QString z;
};

//定义 给流式发送信息结构体
struct StreamInfo
{
    int alarmtype;
    QString target;
    QString startIds;
    QString endIds;
    QString powerdatas;

    StreamInfo(int a = 0, const QString& t = "", const QString& s = "", const QString& e = "",const QString& p = "")
        : alarmtype(a), target(t), startIds(s), endIds(e),powerdatas(p)
    {

    }
};

struct SqlFeaRecord{
    std::vector<std::vector<float> > sample;
    std::vector<int> label;
};

class RamdomForestCalculate : public QObject
{
    Q_OBJECT

public:
    explicit RamdomForestCalculate(QObject *parent = nullptr);
    std::vector<float> QstrToFeature(const QString& qstr);

    //1.查询功率样本(废弃函数)
    QString QueryPowerData(const StreamInfo& alarmInfo);

    //2.发送给流式的消息
    void SendStreamAlarminfo(const StreamInfo& alarmInfo);

    //3.查询函数
    bool queryRecordsByLabel(const QString &dbFileName,
            std::map<std::string, std::pair<std::vector<SACRecord>, std::vector<SACRecord>>>& data);

    //4.接受DC消息，保存振动数据
    int Save_SACDATA(const Dc_SacData& sacdata);

    //5.判断报警
    int judge_alarm();

    //6.解析查询到的振动值
    void DealRecord(const std::map<std::string, std::pair<std::vector<SACRecord>, std::vector<SACRecord>>>& data, std::map<std::string, SqlFeaRecord>& result);

    //7.重新训练
    void Retrain();

signals:
    void nameChanged();
    void somethingDone(const QString &result);

private:
    //QString m_name;
    //DBFunc *dbFunc;
    TcpServerManager *m_tcpServerManager;
    std::map<std::string, RandomForestClassifier> m_rf_map;
};


#endif // RAMDOMFORESTCALCULATE_H
