#ifndef MTCPCLIENT_H
#define MTCPCLIENT_H

#include <QObject>
#include "MTcpSocketControl.h"

class MTcpClient : public QObject
{
    Q_OBJECT
public:
    explicit MTcpClient(QObject *parent = nullptr);
    bool connectHost(const QString& id, const QString& ip, quint16 port);
    void sendData(const QString& data, const QString& id);
signals:
    void recvData(const QString& id, const QString& data);

private:
    QMap<QString, QSharedPointer<MTcpSocketControl>> m_connections;
};

#endif // MTCPCLIENT_H
