#ifndef MTCPSERVER_H
#define MTCPSERVER_H

#include "MTcpSocketControl.h"
//#include "common/Single.h"
//#include "common/tmsMarco.h"
#include <QSharedPointer>
#include <QTcpServer>

enum ServerSource {
    SSProcessStart,
    SSProcessEnd
};

//服务器接口来源
//const QMap<QString, ServerSource> const_map_server_source = {
//    { const_str_process_start, SSProcessStart },
//    { const_str_process_end, SSProcessEnd }
//};

class MTcpServer : public QTcpServer {
    Q_OBJECT
public:
    explicit MTcpServer(QObject* parent = nullptr);

    void setMsgHandle(MsgHandle handle);
    bool startServer(quint16 port);
    void sendData(const QString& data, const QString& id = "broadcast");

    void incomingConnection(qintptr handle) override;
signals:
    void recvData(const QString& id, const QString& data);

private:
    QMap<QString, QSharedPointer<MTcpSocketControl>> m_connections;
    MsgHandle m_handle = nullptr;
};

#endif // MTCPSERVER_H
