#ifndef TCPSERVERMANAGER_H
#define TCPSERVERMANAGER_H

#include "tcp/MTcpServer.h"
#include <QObject>
#include <QDebug>


#define DC_MESSAGE "dc_sacdata"
#define TMS_MESSAGE "TMS_train"


//siger_dc 发送过来的数据
struct Dc_SacData
{
    QString source;   //数据源标识
    QString sacFile;  //sac原始数据文件名
    QString target;   //唯一标识
    QString startIds;  //开始时间
    QString endIds;    //结束时间
};


class TcpServerManager : public QObject
{
    Q_OBJECT

public:
    explicit TcpServerManager(QObject* parent = nullptr);

    // 可选：提供服务器控制方法
    bool startServer(quint16 port = 8080);
    void stopServer();
    bool isRunning() const;

signals:
    void getdc_sacdata(const Dc_SacData &sac_data);

    void TMSTrain();

private slots:
    void onDataReceived(const QString& clientId, const QString& data);

private:
    QString handleMessage(const QString& data, const QString& head);

    MTcpServer m_server;
};

#endif // TCPSERVERMANAGER_H
