﻿using Siger.WeComApi.Common.ExcelImport;
using System;
using System.Collections.Generic;
using System.Text;

namespace Siger.WeComApi.Common.ExcelImport
{
    public class ExportEmployeeSkillMatrix: ImportBase
    {
        /// <summary>
        /// 员工姓名
        /// </summary>
        [ExcelColumn("员工姓名")]
        public string EmployeeName { get; set; }


        /// <summary>
        /// 工号
        /// </summary>
        [ExcelColumn("工号")]
        public string WorkCode { get; set; }

        /// <summary>
        /// 部门
        /// </summary>
        [ExcelColumn("部门")]
        public string Section { get; set; }

        /// <summary>
        /// 岗位
        /// </summary>
        [ExcelColumn("岗位")]
        public string Post { get; set; }

        /// <summary>
        /// 员工技能明细
        /// </summary>
        public List<ExportSkillInfo> EmployeeSkillDetail { get; set; } = new List<ExportSkillInfo>();

        /// <summary>
        /// 合计
        /// </summary>
        [ExcelColumn("合计")]
        public int Total { get; set; }
    }

    public class ExportSkillInfo
    {
        public int Id { get; set; }

        /// <summary>
        /// 技能名称
        /// </summary>
        public string SkillName { get; set; }

        /// <summary>
        /// 技能id
        /// </summary>
        public int SkillId { get; set; }

        /// <summary>
        /// 技能等级描述
        /// </summary>
        public string LevelDesc { get; set; }

        /// <summary>
        /// 技能等级
        /// </summary>
        public int Level { get; set; }

        /// <summary>
        /// 备注
        /// </summary>
        public string Remark { get; set; }
    }
}
