﻿using Microsoft.Extensions.DependencyInjection;
using Microsoft.Extensions.Logging;
using Siger.CommonUtil.Logging;
using System;
using System.Diagnostics;
using System.Linq;

namespace Siger.WeComApi.Common.Logger
{
    /// <summary>
    /// 供静态类使用，可注入类型，请注入ISigerLogger<> 使用
    /// 问题，多层调用，堆栈信息不准确
    /// </summary>
    public static class SigerLogger
    {
        /// <summary>
        /// 忽略掉的调用栈节点
        /// </summary>
        private readonly static string[] IgnoreStackNodes = { "SigerLogger" };

        public static void Error(string message, string filter1 = "", string filter2 = "")
        {
            var marak = GetMarker();
            var logger = GetLogger(marak);
            logger.Error(marak, message, filter1, filter2);
        }

        public static void Error(object messageObject, string filter1 = "", string filter2 = "")
        {
            var marak = GetMarker();
            var logger = GetLogger(marak);
            logger.Error(marak, messageObject, filter1, filter2);
        }

        public static void Error(Exception ex, string message, string filter1 = "", string filter2 = "")
        {
            var marak = GetMarker();
            var logger = GetLogger(marak);
            logger.Error(marak, ex, message, filter1, filter2);
        }

        public static void Error(Exception ex, object messageObject, string filter1 = "", string filter2 = "")
        {
            var marak = GetMarker();
            var logger = GetLogger(marak);
            logger.Error(marak, ex, messageObject, filter1, filter2);
        }

        public static void Info(object messageObject, string filter1 = "", string filter2 = "")
        {
            var marak = GetMarker();
            var logger = GetLogger(marak);
            logger.Info(marak, messageObject, filter1, filter2);
        }

        public static void Warn(string message, string filter1 = "", string filter2 = "")
        {
            var marak = GetMarker();
            var logger = GetLogger(marak);
            logger.Warn(marak, message, filter1, filter2);
        }

        public static void Warn(object messageObject, string filter1 = "", string filter2 = "")
        {
            var marak = GetMarker();
            var logger = GetLogger(marak);
            logger.Warn(marak, messageObject, filter1, filter2);
        }

        public static void Warn(Exception ex, object messageObject, string filter1 = "", string filter2 = "")
        {
            var marak = GetMarker();
            var logger = GetLogger(marak);
            logger.Warn(marak, ex, messageObject, filter1, filter2);
        }

        public static void Debug(object message, string filter1 = "", string filter2 = "")
        {
            var marak = GetMarker();
            var logger = GetLogger(marak);
            logger.Debug(marak, message, filter1, filter2);
        }

        private static ILogger GetLogger(LogMarker marker)
        {
            var loggerFactory = ServiceContainer.Current.GetService<ILoggerFactory>();
            return loggerFactory.CreateLogger(marker.Namespace);
        }

        /// <summary>
        /// 获取Marker
        /// </summary>
        /// <returns></returns>
        private static LogMarker GetMarker()
        {
            LogMarker marker = null;
            try
            {
                var stackTrace = new StackTrace();
                foreach (var frame in stackTrace.GetFrames())
                {
                    var method = frame.GetMethod();
                    var declaringType = method.DeclaringType;
                    if (!IgnoreStackNodes.Contains(declaringType.Name))
                    {
                        marker = new LogMarker(declaringType.Namespace, declaringType.Name, method.Name);
                        break;
                    }
                }
            }
            catch (Exception ex)
            {
                marker = new LogMarker("Siger.WeComApi.Common.Logger", "SigerLogger", "GetMarker");
                var logger = GetLogger(marker);
                logger.Error(marker, ex);
            }
            return marker;
        }
    }
}
