﻿using System;
using System.Collections.Generic;

namespace Siger.ApiCommon.Result
{
    public class SectionShiftResult : OtherObjectResult
    {
        public IList<SectionGroupInfo> group { get; set; }

        public object data { get; set; }

        public Enum msg { get; set; }

        public int ret { get; set; }

        public SectionShiftResult()
        {
            group = new List<SectionGroupInfo>();
        }
    }

    public class SectionGroupShiftResult : OtherObjectResult
    {
        public List<SectionShiftGroup> data { get; set; }

        public List<SectionGroupInfo> group { get; set; }

        public List<SectionShiftInfo> shift { get; set; }

        public Enum msg { get; set; }

        public int ret { get; set; }

        public SectionGroupShiftResult()
        {
            data = new List<SectionShiftGroup>();
            group = new List<SectionGroupInfo>();
            shift = new List<SectionShiftInfo>();
        }
    }

    public class SectionShiftGroup
    {
        public List<SectionShiftGroupInfo> group { get; set; }

        public string time { get; set; }

        public string code { get; set; }

        public SectionShiftGroup()
        {
            group = new List<SectionShiftGroupInfo>();
        }
    }

    public class SectionShiftGroupInfo
    {
        public int shiftid { get; set; }

        public IEnumerable<int> groupids { get; set; }

        public SectionShiftGroupInfo()
        {
            groupids = new List<int>();
        }
    }

    public class SectionGroupInfo
    {
        public int id { get; set; }

        public string text { get; set; }
    }

    public class SectionShiftInfo
    {
        public int id { get; set; }

        public string title { get; set; }
    }

    public class UserGroupSectionResult : OtherObjectResult
    {
        public int ret { get; set; } = 1;

        public string msg { get; set; } = string.Empty;

        public IList<UserGroupSection> data { get; set; }

        public UserGroupSectionResult()
        {
            data = new List<UserGroupSection>();
        }
    }

    public class UserGroupSection
    {
        public IList<UserGroupSectionChildrenInfo> children { get; set; }

        public int id { get; set; }

        public string title { get; set; }

        public UserGroupSection()
        {
            children = new List<UserGroupSectionChildrenInfo>();
        }
    }

    public class UserGroupSectionChildrenInfo
    {
        public int groupID { get; set; }

        public string groupTitle { get; set; }

        public List<UserGroupSectionChildrenInfo> children { get; set; }
        public UserGroupSectionChildrenInfo()
        {
            children = new List<UserGroupSectionChildrenInfo>();
        }
    }
}
