﻿using System.Collections.Generic;

namespace Siger.WeComApi.Core.Dto.Response
{
    public class ResponseGetProduct
    {
        public int id { get; set; }

        public string name { get; set; }

        public string code { get; set; }

        public string drawingcode { get; set; }

        public string remark { get; set; }

        public string image { get; set; }

        /// <summary>
        /// 工艺版本数量
        /// </summary>
        public string ProcessVersion { get; set; }

        /// <summary>
        /// 默认工艺版本
        /// </summary>
        public string DefaultVersion { get; set; }

        /// <summary>
        /// 工序组id
        /// </summary>
        public int RouteGroupId { get; set; }

        /// <summary>
        /// 工序信息
        /// </summary>

        public List<ResponseRouteInfo> RouteInfo { get; set; } = new List<ResponseRouteInfo>();
    }

    public class ResponseRouteInfo
    {
        /// <summary>
        /// 工序id
        /// </summary>
        public int Id { get; set; }

        /// <summary>
        /// 工序序号
        /// </summary>
        public int SerialNumber { get; set; }

        /// <summary>
        /// 工序名称
        /// </summary>
        public string RouteName { get; set; }

        /// <summary>
        /// 工序说明
        /// </summary>
        public string RouteDesc { get; set; }

        /// <summary>
        /// 额定工时
        /// </summary>
        public double Timing { get; set; }

        /// <summary>
        /// 控制类型:1无限制 2精确控制
        /// </summary>
        public int ControlType { get; set; }

        /// <summary>
        /// 标准工序id
        /// </summary>
        public int StandardId { get; set; }

        /// <summary>
        /// 工艺过程
        /// </summary>
        public string craft_process { get; set; }

        /// <summary>
        /// 流转类型  1手动 2自动
        /// </summary>
        public int transfer_type { get; set; }

        public int route_type { get; set; }
    }
}
