﻿using Siger.Middlelayer.Repository.Repositories;
using Siger.WeComApi.Common.Enums;
using Siger.WeComApi.Core.Domain.Entity;
using Siger.WeComApi.Core.Repository;
using System;
using System.Linq;

namespace Siger.WeComApi.Repository.Repositories
{
    internal class SigerWeComCompanyRepository : ApiConfigRepositoryBase<siger_wecom_company>, ISigerWeComCompanyRepository
    {
        /// <summary>
        /// 主库,写操作
        /// </summary>
        protected new readonly BaseDataDbContext DbMaster;

        /// <summary>
        /// 从库,读操作
        /// </summary>
        protected new readonly BaseDataReadDbContext DbSlave;
        public SigerWeComCompanyRepository(BaseDataDbContext dbMaster, BaseDataReadDbContext dbSlave) : base(dbMaster, dbSlave)
        {
            this.DbMaster = dbMaster; this.DbSlave = dbSlave;
        }

        public siger_wecom_company GetSigerWeComCompany(string id,string corpid)
        {
            var companies = DbSlave.siger_wecom_company.Where(f => f.status == (int)RowState.Valid);
            if (companies != null && !string.IsNullOrEmpty(id))
            {
                companies = companies.Where(c => c.id == id);
            }
            if (companies != null && !string.IsNullOrEmpty(corpid))
            {
                companies = companies.Where(c => c.corpid == corpid);
            }
            return companies.FirstOrDefault();
        }

        public string AddSigerWeComCompany(siger_wecom_company siger_wecom_company)
        {
            siger_wecom_company dbWeComCompany = GetSigerWeComCompany("",siger_wecom_company.corpid);
            //判断该公司信息是否已存在于数据库
            if (dbWeComCompany != null && !string.IsNullOrEmpty(dbWeComCompany.corpid))
            {
                siger_wecom_company.id = dbWeComCompany.id;
                siger_wecom_company.createtime = dbWeComCompany.createtime;
                siger_wecom_company.status = dbWeComCompany.status;
                siger_wecom_company.updatetime = DateTime.Now;
                DbMaster.siger_wecom_company.Update(siger_wecom_company);
                DbMaster.SaveChanges();
            }
            else
            {
                siger_wecom_company.id =  Guid.NewGuid().ToString();
                siger_wecom_company.createtime = DateTime.Now;
                siger_wecom_company.status = (int)RowState.Valid;
                DbMaster.siger_wecom_company.Add(siger_wecom_company);
                DbMaster.SaveChanges();
            }
            return siger_wecom_company.corpid;
        }

    }
}
