﻿using System.ComponentModel;

namespace Siger.WeComApi.Common.ExcelImport
{
    /// <summary>
    /// import and export operation, start from 9100000
    /// </summary>
    public enum ImportEnum
    {
        [Description("操作失败")]
        ImportFailed = 0,

        [Description("操作成功")]
        Succefull,

        [Description("部门不能为空")]
        SectionIsEmpty = 9100000,

        [Description("岗位不能为空")]
        UsergroupIsEmpty,

        [Description("手机号码格式不正确")]
        MobileIsInvalid,

        [Description("邮箱格式不正确")]
        EmailIsInvalid,

        [Description("产品不能为空")]
        ProductNameIsEmpty,

        [Description("产品编号不能为空")]
        ProductCodeIsEmpty,

        [Description("产品图纸号不能为空")]
        ProductDrawCodeIsEmpty,

        [Description("父级类型不能为空")]
        ParentTypeIsEmpty,

        [Description("设备名称不能为空")]
        MachineNameIsEmpty,

        [Description("设备分类(一级)不能为空")]
        MachineParentTypeIsEmpty,

        [Description("设备编号不能为空")]
        MachineCodeIsEmpty,

        [Description("无效")]
        Invalid,

        [Description("日期格式不正确")]
        DateTimeIsInValid,

        [Description("无效的数字格式")]
        NumberIsValid,

        [Description("设备层级不能为空")]
        MachineLevelIsEmpty,

        [Description("没有数据可供导入")]
        NoRecordForImport,
        
        [Description("程序号不能为空")]
        ProgramNoIsEmpty,

        [Description("主轴号不能为空")]
        SpindleNoIsEmpty,

        [Description("刀位号不能为空")]
        ToolLocationNameIsEmpty,

        [Description("刀位图纸号不能为空")]
        ToolDrawCodeIsEmpty,

        [Description("额定寿命不能为空")]
        RateLifeIsEmpty,

        [Description("刀具名称不能为空")]
        ToolNameIsEmpty,

        [Description("更换时间不能为空")]
        ChangeTimeIsEmpty,

        [Description("更换原因不能为空")]
        ChangeReasonIsEmpty,

        [Description("更换原因未找到")]
        ChangeReasonNotFound,

        [Description("列名未找到")]
        ColumnNameNotFound,

        [Description("工单号不能为空")]
        WorkOrderIsEmpty,

        [Description("交付时间不能为空")]
        DeliveryTimeIsEmpty,

        [Description("标准节拍不是正整数")]
        CycleTimeIsInt,

        [Description("订单数量不是正整数")]
        QuantityIsInt,

        [Description("姓名不能为空")]
        NameIsEmpty,

        [Description("手机号不能为空")]
        MobileIsEmpty,

        [Description("编号不能为空")]
        lineIsEmpty,

        [Description("简码不能为空")]
        TcodeIsEmpty,

        [Description("标准节拍不能为空")]
        BeatSetIsEmpty,

        [Description("日标准产量不能为空")]
        OutputIsEmpty,

        [Description("一级类型不能为空")]
        LevelOneTypeIsEmpty,

        [Description("备件类型名称已存在")]
        SparepartTypeIsExist,

        [Description("备件名称已存在")]
        SparepartIsExist,

        [Description("设备父级不能为空")]
        MachineParentIsEmpty,

        [Description("设备子级不能为空")]
        MachineChildIsEmpty,

        [Description("故障类型不能为空")]
        FaultTypeIsEmpty,

        [Description("备件类型不能为空")]
        SparepartTypeIsEmpty,

        [Description("备件编号不能为空")]
        SparepartCodeIsEmpty,

        [Description("备件名称不能为空")]
        SparepartNameIsEmpty,

        [Description("工序名称不能为空")]
        RouteNameIsEmpty,

        [Description("产线层级不能为空")]
        LevelSectionIsEmpty,

        [Description("ID不能为空")]
        IdIsEmpty,

        [Description("ID格式不正确")]
        IdIsInVald,

        [Description("开始时间不能为空")]
        StartTimeIsEmpty,

        [Description("结束时间不能为空")]
        EndTimeIsEmpty,

        [Description("设备属性不能为空")]
        AttributeIsEmpty,

        [Description("系统工号不能为空")]
        UserCodeIsEmpty,

        [Description("轮班组不能为空")]
        WorkgroupIsEmpty,

        [Description("班次不能为空")]
        ShiftIsEmpty,

        [Description("规格不能为空")]
        SpecIsEmpty,

        [Description("料号不能为空")]
        SNIsEmpty,

        [Description("供应商不能为空")]
        SupplierIsEmpty,

        [Description("固定资产编号不能为空")]
        AssetsNoIsEmpty,

        [Description("设备类型不能为空")]
        MachineNCIsEmpty,

        [Description("设备分类(二级)不能为空")]
        MachineChildTypeIsEmpty,

        [Description("类别不能为空")]
        TypeIsEmpty,

        [Description("名称不能为空")]
        SupplierNameIsEmpty,

        [Description("公司名称不能为空")]
        CompanyNameIsEmpty,

        [Description("公司地址不能为空")]
        CompanyAddressIsEmpty,

        [Description("联系人不能为空")]
        LinkmanIsEmpty,

        [Description("电话不能为空")]
        TelephoneIsEmpty,

        [Description("阈值不能为空")]
        ThresholdIsEmpty=910067,
        [Description("工装类型不能为空")]
        ToolsTypeIsEmpty,

        [Description("工装编号不能为空")]
        ToolsCodeIsEmpty,

        [Description("工装名称不能为空")]
        ToolsNameIsEmpty,
    }

    public enum EchartCategory
    {
        None,

        [Description("OEE")]
        Oee,

        [Description("OEE,OEE1,OEE2,OEE3")]
        OeeDetail,

        [Description("切片百分比堆积柱状图")]
        SlicePercentColumnStacked,

        [Description("效率分析统计")]
        EfficiencyAnalysis
    }
}
