﻿

namespace Siger.WeComApi.Common.ExcelImport
{
    public class MeasureCategoryList : MeasureCategoryTemplate
    {
        [ExcelColumn("序号")]
        public string No { get; set; }
    }

    public class MeasureCategoryTemplate : ImportBase
    {
        [ExcelColumn("量具类型*")]
        public string Name { get; set; }

        [ExcelColumn("上级量具类型")]
        public string Parent { get; set; }
    }


    public class MeasureList : MeasureTemplate
    {
        [ExcelColumn("序号")]
        public string No { get; set; }
    }

    public class MeasureTemplate : ImportBase
    {
        [ExcelColumn("量具类型*")]
        public string Category { get; set; }

        [ExcelColumn("量具编号*")]
        public string Code { get; set; }

        [ExcelColumn("量具名称*")]
        public string Name { get; set; }

        [ExcelColumn("规格型号*")]
        public string Spec { get; set; }

        [ExcelColumn("状态*")]
        public string Status { get; set; }

        [ExcelColumn("是否标准量具")]
        public string IsStandard { get; set; }

        [ExcelColumn("测量范围")]
        public string Range { get; set; }

        [ExcelColumn("精度")]
        public string Accuracy { get; set; }

        [ExcelColumn("管理级别")]
        public string Level { get; set; }

        [ExcelColumn("检定方式")]
        public string CheckType { get; set; }

        [ExcelColumn("供应商信息")]
        public string Supplier { get; set; }

        [ExcelColumn("制造商信息")]
        public string Manufacturer { get; set; }

        [ExcelColumn("出厂编号")]
        public string FactoryNumber { get; set; }

        [ExcelColumn("出厂日期")]
        public string FactoryDate { get; set; }

        [ExcelColumn("所属部门*")]
        public string Depart { get; set; }

        [ExcelColumn("使用部门*")]
        public string UseDepart { get; set; }

        [ExcelColumn("保管人*")]
        public string Keeper { get; set; }

        [ExcelColumn("采购价格")]
        public string Price { get; set; }

        [ExcelColumn("采购时间")]
        public string PurchaseDate { get; set; }

        [ExcelColumn("使用地点")]
        public string Position { get; set; }

        [ExcelColumn("备注")]
        public string Remark { get; set; }
    }
}
