﻿

namespace Siger.WeComApi.Common.ExcelImport
{
    public class SparepartListForImport : ImportBase
    {
        [ExcelColumn("备件编号")]
        [EmptyValidate("SparepartCodeIsEmpty")]
        public string Code { get; set; }

        [ExcelColumn("备件名称")]
        [EmptyValidate("SparepartNameIsEmpty")]
        public string Name { get; set; }

        [ExcelColumn("规格型号")]
        public string Param { get; set; }

        [ExcelColumn("备件类型")]
        [EmptyValidate("SparepartTypeIsEmpty")]
        public string Type { get; set; }

        [ExcelColumn("生产厂商/品牌")]
        public string Brand { get; set; }

        [ExcelColumn("描述")]
        public string Description { get; set; }

        [ExcelColumn("材质")]
        public string Material { get; set; }

        [ExcelColumn("单价")]
        public string Price { get; set; }

        [ExcelColumn("库存位置")]
        public string Location { get; set; }

        [ExcelColumn("库存")]
        public double Sku { get; set; }

        [ExcelColumn("最低库存")]
        public double MinSku { get; set; }

        [ExcelColumn("最高库存")]
        public double MaxSku { get; set; }

        [ExcelColumn("负责人")]
        public string UserCode { get; set; }

        [ExcelColumn("是否需要置换（1-是，0-否）")]
        public int IsExchange { get; set; }

        [ExcelColumn("供应商")]
        public string Supplier { get; set; }

        [ExcelColumn("计量单位")]
        public string Unit { get; set; }

        [ExcelColumn("货期")]
        public string DeliveryDay { get; set; }

        [ExcelColumn("备注")]
        public string Remark { get; set; }

        [ExcelColumn("维修上限")]
        public string RepairUpperLimit { get; set; }

        [ExcelColumn("最小起订量")]
        public string MinOrder{ get; set; }

        [ExcelColumn("审批人")]
        public string ApprovalUser { get; set; }
        /// <summary>
        /// 适用设备
        /// </summary>
        [ExcelColumn("适用设备")]
        public string sectionName { get; set; }
        /// <summary>
        /// 重要成都
        /// </summary>
        [ExcelColumn("重要等级")]
        public string importlevel { get; set; }
    }
}
