﻿using System;

namespace Siger.WeComApi.Common.Helpers
{
    /// <summary>
    /// 工具类
    /// </summary>
    public class SigerUtils
    {
        // 转换时间的方法
        public static DateTime ToDate(string strDate)
        {
            DateTime dateTime = DateTime.ParseExact(strDate, "yyyyMMdd", System.Globalization.CultureInfo.CurrentCulture);
            return dateTime;
        }

        /// <summary>
        /// 将日志系统的传入时间转成int类型
        /// </summary>
        /// <param name="time"></param>
        /// <returns></returns>
        public static int LogDateToInt(string time)
        {
            var resTime = time.Split(':');
            return int.Parse(resTime[0] + resTime[1] + resTime[2]);
        }

        /// <summary>
        /// 获取剩余天数
        /// </summary>
        /// <param name="UnixTime"></param>
        /// <returns></returns>
        public static int GetRemainTimeForUnix(string UnixTime)
        {
            if (string.IsNullOrEmpty(UnixTime))
            {
                return 0;
            }
            var sp = TimeSpanForUnix(UnixTime);

            return sp > 0 ? sp : 0;
        }

        public static int GetRemainTimeForStr(string UnixTime)
        {
            if (string.IsNullOrEmpty(UnixTime))
            {
                return 0;
            }
            var sp = TimeSpanForStr(UnixTime);

            return sp > 0 ? sp : 0;
        }

        /// <summary>
        /// 获取授权状态
        /// </summary>
        /// <param name="UnixTime"></param>
        /// <param name="status"></param>
        /// <returns></returns>
        public static int GetLicStateForUnix(string UnixTime, int status)
        {
            if (string.IsNullOrEmpty(UnixTime))
            {
                return status;
            }
            var sp = TimeSpanForUnix(UnixTime);

            return sp >= 0 ? status : 3;//3代表过期
        }

        public static int GetLicStateForStr(string Time, int status)
        {
            if (string.IsNullOrEmpty(Time))
            {
                return status;
            }
            var sp = TimeSpanForStr(Time);

            return sp >= 0 ? status : 3;//3代表过期
        }

        /// <summary>
        /// 获取相差天数 UnixTime
        /// </summary>
        /// <param name="UnixTime"></param>
        /// <returns></returns>
        public static int TimeSpanForUnix(string UnixTime)
        {
            DateTime now = DateTime.Now;
            DateTime licDate = UnixTimeHelper.ConvertStringDateTime(UnixTime);
            TimeSpan sp = licDate.Subtract(now);

            return sp.Days;
        }

        public static int TimeSpanForStr(string Time)
        {
            DateTime now = DateTime.Now;
            DateTime licDate = DateTime.Parse(Time);
            TimeSpan sp = licDate.Subtract(now);

            return sp.Days;
        }
    }
}
