﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Net;
using System.Text;
using System.Threading.Tasks;
using System.Timers;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using Siger.WeComApi.Common.cache;

namespace Siger.ApiTPM.Utilities
{
    public class WeComThirdHelper
    {
        //保存ticket与第三方应用凭证
        public static string ticket { get; set; }
        public static string suite_access_token { get; set; }
        //企业微信后台开发者设置的token, corpID, EncodingAESKey
        private readonly string Token = "VA7Ua2huaUKmjhaxakxCO2iYQYKCa6";
        private readonly string CorpID = "ww99ade71da501313d";
        private readonly string EncodingAESKey = "M1s6eo7BEBmxNw2Tj8TeQPKKT6zqKOyYRWkpuN8kmnn";
        private readonly string ProviderSecret = "YfzQU3nKNSLAPM9-c4kHtP5hCTFG2p3xbJlFtsIlsxCPgs15079tYNL94Xb5Rf0s";
        //企微应用关联的小程序信息
        private readonly string SuiteID = "wwb172cebe81bae0af";
        private readonly string SuiteSecret = "aHB2yPhKX8AsRp-c_8UBrhOju7ahxu8Rq3LLuRVrRo8";

        //基础地址
        private static string baseUrl = "https://qyapi.weixin.qq.com/cgi-bin/";
        //服务商相关
        private static string serviceUrl = baseUrl + "service/";
        private string suiteTokenUrl = serviceUrl + "get_suite_token";
        private string preAuthCodeUrl = serviceUrl + "get_pre_auth_code?suite_access_token=%s";
        private string permanentCodeUrl = serviceUrl + "get_permanent_code?suite_access_token=";
        private string sessionInfoUrl = serviceUrl + "set_session_info?suite_access_token=%s";
        private string installUrl = "https://open.work.weixin.qq.com/3rdapp/install?suite_id=%s&pre_auth_code=%s&redirect_uri=%s&state=STATE";

        private string providerTokenUlr = serviceUrl + "get_provider_token";
        private string registerCodeUrl = serviceUrl + "get_register_code?provider_access_token=%s";
        private string registerUrl = "https://open.work.weixin.qq.com/3rdservice/wework/register?register_code=%s";

        private string ssoAuthUrl = "https://open.work.weixin.qq.com/wwopen/sso/3rd_qrConnect?appid=%s&redirect_uri=%s&state=%s&usertype=%s";
        private string loginInfoUrl = serviceUrl + "get_login_info?access_token=%s";
        //第三方应用身份验证
        private string getuserinfo3rdUrl = serviceUrl + "miniprogram/jscode2session";
        private static string userUrl = baseUrl + "user/";
        private string getUserAllInfo = userUrl + "get";
        //加密coprid
        private string corpIDToOpenCorpIDUrl = serviceUrl + "corpid_to_opencorpid";

        //通讯录转译
        private string contactUploadUrl = serviceUrl + "media/upload?provider_access_token=%s&type=%s";
        private string contactTransUrl = serviceUrl + "contact/id_translate?provider_access_token=%s";
        private string transResultUrl = serviceUrl + "batch/getresult?provider_access_token=%s&jobid=%s";
        //公司相关
        private string corpTokenUrl = serviceUrl + "get_corp_token?suite_access_token=";
        private string departmentUrl = baseUrl + "department/list?access_token=%s";
        private string userSimplelistUrl = baseUrl + "user/simplelist?access_token=%s&department_id=%s&fetch_child=%s";
        private string userDetailUrl = baseUrl + "user/get?access_token={access_token}&userid={user_id}";
        //外部联系人

        //获取配置了客户联系功能的成员列表 https://work.weixin.qq.com/api/doc/90001/90143/92576
        private string extContactFollowUserListUrl = baseUrl + "externalcontact/get_follow_user_list?access_token=%s";
        //获取客户列表  https://work.weixin.qq.com/api/doc/90001/90143/92264
        private string extContactListUrl = baseUrl + "externalcontact/list?access_token=%s&userid=%s";
        //获取客户群列表 https://work.weixin.qq.com/api/doc/90001/90143/93414
        private string extContactGroupchatUrl = baseUrl + "externalcontact/groupchat/list?access_token=%s";
        //消息推送
        private string messageSendUrl = baseUrl + "message/send?access_token=%s";
        //素材管理
        //https://open.work.weixin.qq.com/api/doc/90001/90143/90389
        //type	是	媒体文件类型，分别有图片（image）、语音（voice）、视频（video），普通文件（file）
        private string mediaUploadUrl = baseUrl + "media/upload?access_token=%s&type=%s";
        private string mediaUploadimgUrl = baseUrl + "media/uploadimg?access_token=%s";
        private string mediaGetUrl = baseUrl + "media/get?access_token=%s&media_id=%s";
        private string mediaGetJssdkUrl = baseUrl + "media/get/jssdk?access_token=%s&media_id=%s";
        //审批
        //审批应用 https://work.weixin.qq.com/api/doc/90001/90143/91956
        private string oaCopyTemplateUrl = "oa/approval/copytemplate?access_token=%s";
        private string oaGetTemplateUrl = "/oa/gettemplatedetail?access_token=%s";
        private string oaApplyEventUrl = "oa/applyevent?access_token=%s";
        private string oaGetApprovalUrl = "oa/getapprovaldetail?access_token=%s";
        //审批流程引擎 https://work.weixin.qq.com/api/doc/90001/90143/93798
        private string openApprovalDataUrl = baseUrl + "corp/getopenapprovaldata?access_token=ACCESS_TOKEN";

        public string GetToken()
        {
            return Token;
        }

        public string GetCorpID()
        {
            return CorpID;
        }

        public string GetEncodingAESKey()
        {
            return EncodingAESKey;
        }

        public string GetSuiteID()
        {
            return SuiteID;
        }

        public string SetSuitTicket(string ticketInfo)
        {
            ticket = ticketInfo;
            return ticket;
        }

        public string GetTicket()
        {
            return ticket;
        }

        public string GetSuiteSecret()
        {
            return SuiteSecret;
        }
        

        public string GetPreAuthCodeUrl()
        {
            return preAuthCodeUrl;
        }

        public string GetPermanentCodeUrl()
        {
            return permanentCodeUrl;
        }

        public string SetSuiteToken(string suitToken)
        {
            suite_access_token = suitToken;
            return suite_access_token;
        }

        public string GetSuiteTokenUrl()
        {
            return suiteTokenUrl;
        }

        /// <summary>
        /// 获取客户企业凭证
        /// </summary>
        /// <returns></returns>
        public string GetCorpAccessToken(string corpid,string permanentCode)
        {
            string preAccessToken = corpid + "AccessToken";
            string accessToken = CacheUtility.Instance.GetString(preAccessToken);
            if (string.IsNullOrEmpty(accessToken))
            {
                JObject postJson = new JObject();
                postJson["auth_corpid"] = corpid;
                postJson["permanent_code"] = permanentCode;
                string url = corpTokenUrl + GetSuiteAccessToken();
                string response = post(url, postJson);
                JObject accessTokenJson = (JObject)JsonConvert.DeserializeObject(response);
                if (accessTokenJson["errcode"] != null)
                {
                    string errorMsg = string.Format("获取企业{0}应用凭证失败,errcode: {1},errmsg: {2}", corpid, accessTokenJson["errcode"], accessTokenJson["errmsg"]);
                    throw new Exception(errorMsg);
                }
                accessToken = accessTokenJson["access_token"].ToString();
                CacheUtility.Instance.Set(preAccessToken, accessToken, 7150); //2小时过期的token，此处提前50秒清空
            }
            return accessToken;
        }

        /// <summary>
        /// 第三方应用 获取访客身份url（简单信息）
        /// </summary>
        /// <returns></returns>
        public string GetUserinfo3rdUrl()
        {
            return getuserinfo3rdUrl;
        }

        /// <summary>
        /// 第三方应用 获取访客身份（敏感信息）
        /// </summary>
        /// <returns></returns>
        public string GetUserAllInfo(string accessToken,string userid)
        {
            JObject postJson = new JObject();
            var url = getUserAllInfo + "?access_token=" + accessToken + "&userid=" + userid;
            string response = post(url, null);
            return response;
        }

        /// <summary>
        /// 获取第三方应用凭证
        /// </summary>
        /// <returns></returns>
        public string GetSuiteAccessToken()
        {
            var suiteAccessToken = CacheUtility.Instance.GetString("SuiteAccessToken");
            if (string.IsNullOrEmpty(suiteAccessToken))
            {
                JObject postJson = new JObject();
                postJson["suite_id"] = SuiteID;
                postJson["suite_secret"] = SuiteSecret;
                postJson["suite_ticket"] = GetTicket();
                if (string.IsNullOrEmpty(postJson["suite_ticket"].ToString()))
                {
                    string errorMsg = "获取suite_ticket失败，请手动推送ticket，或等待10分钟系统自动推送";
                    throw new Exception(errorMsg);
                }
                string response = post(suiteTokenUrl, postJson);
                JObject suiteAccessTokenJson = (JObject)JsonConvert.DeserializeObject(response);
                if (suiteAccessTokenJson["errcode"] != null)
                {
                    string errorMsg = string.Format("获取第三方应用凭证失败,errcode: {0},errmsg: {1}", suiteAccessTokenJson["errcode"], suiteAccessTokenJson["errmsg"]);
                    throw new Exception(errorMsg);
                }
                suiteAccessToken = suiteAccessTokenJson["suite_access_token"].ToString();
                CacheUtility.Instance.Set("SuiteAccessToken", suiteAccessToken, 7150); //2小时过期的token，此处提前50秒清零
            }
            return suiteAccessToken;
        }

        /// <summary>
        /// 获取供应商token(西格的AccessToken)
        /// </summary>
        /// <returns></returns>
        public string GetProviderAccessToken()
        {
            var providerToken = CacheUtility.Instance.GetString("ProvideAccessToken");
            if (string.IsNullOrEmpty(providerToken)) 
            {
                JObject postJson = new JObject();
                postJson["corpid"] = CorpID;
                postJson["provider_secret"] = ProviderSecret;
                var response = post(providerTokenUlr, postJson);
                JObject providerTokenJson = (JObject)JsonConvert.DeserializeObject(response);
                if (providerTokenJson["errcode"] != null)
                {
                    string errorMsg = string.Format("获取服务商凭证失败,errcode: {0},errmsg: {1}", providerTokenJson["errcode"], providerTokenJson["errmsg"]);
                    throw new Exception(errorMsg);
                }
                providerToken = providerTokenJson["provider_access_token"].ToString();
                CacheUtility.Instance.Set("ProvideAccessToken", providerToken, 7150); //2小时过期的token，此处提前50秒清零
            }
            return providerToken;
        }

        /// <summary>
        /// 转化为加密后的corpid
        /// </summary>
        /// <returns></returns>
        public string ToOpenCorpid(string corpID)
        {
            string provideAccessToken = GetProviderAccessToken();
            string url = corpIDToOpenCorpIDUrl + "?provider_access_token=" + provideAccessToken;
            JObject postJson = new JObject();
            postJson["corpid"] = corpID;
            string response = post(url, postJson);
            JObject openCorpIDJson = (JObject)JsonConvert.DeserializeObject(response);
            if (openCorpIDJson["errcode"] != null)
            {
                string errorMsg = string.Format("openCorpID,errcode: {0},errmsg: {1}", openCorpIDJson["errcode"], openCorpIDJson["errmsg"]);
                throw new Exception(errorMsg);
            }
            
            return openCorpIDJson.ToString();
        }

        /// <summary>
        /// post请求方法
        /// </summary>
        /// <returns></returns>
        public string post(string posturl, JObject json)
        {
            var posdata = JsonConvert.SerializeObject(json);
            var request = (HttpWebRequest)WebRequest.Create(posturl);
            System.Net.ServicePointManager.DefaultConnectionLimit = 300;
            request.Method = "POST";
            request.ContentType = "application/json;charset=UTF-8";
            var byteData = Encoding.UTF8.GetBytes(posdata);
            var length = byteData.Length;
            request.ContentLength = length;
            var writer = request.GetRequestStream();
            writer.Write(byteData, 0, length);
            writer.Close();
            var response = (HttpWebResponse)request.GetResponse();
            var resData = new StreamReader(response.GetResponseStream(), Encoding.GetEncoding("utf-8")).ReadToEnd();
            return resData;
        }
    }
}
