﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using System.Text;

namespace Siger.WeComApi.Core.Domain.Entity
{
    /// <summary>
    /// siger_license 的数据库实体类
    /// </summary>
    [Table("siger_license")]
    public class siger_license : EntityBase
    {
        [Key]
        [Column("id")]
        public int id { get; set; }

        /// <summary>
        /// 客户id
        /// </summary>
        [Column("company_id")]
        public int company_id { get; set; }

        /// <summary>
        /// 项目id
        /// </summary>
        [Column("project_id")]
        public int project_id { get; set; }

        /// <summary>
        /// 授权人员id
        /// </summary>
        [Column("licensor_id")]
        public int licensor_id { get; set; }

        /// <summary>
        /// 授权日期
        /// </summary>
        [Column("lic_date")]
        public string lic_date { get; set; }

        /// <summary>
        /// 授权状态 1->已授权 2->待授权 3->授权过期
        /// </summary>
        [Column("lic_state")]
        public int lic_state { get; set; }

        /// <summary>
        /// 授权类型 1->按日期授权 2->永久授权 3->试用
        /// </summary>
        [Column("lic_type")]
        public int lic_type { get; set; }

        /// <summary>
        /// 授权过期时间
        /// </summary>
        [Column("lic_exp_date")]
        public string lic_exp_date { get; set; }
        /// <summary>
        /// 添加时间
        /// </summary>
        [Column("createtime")]
        public string createtime { get; set; }
        /// <summary>
        /// 创建人id
        /// </summary>
        [Column("creator")]
        public int creator { get; set; }
        /// <summary>
        /// 修改时间
        /// </summary>
        [Column("updatetime")]
        public string updatetime { get; set; }
        /// <summary>
        /// 修改人id
        /// </summary>
        [Column("updator")]
        public int updator { get; set; }

        /// <summary>
        /// 逻辑存在状态 0->不存在 1->存在
        /// </summary>
        [Column("status")]
        public int status { get; set; } = 1;

        /// <summary>
        /// 操作次数
        /// </summary>
        [Column("lic_count")]
        public int lic_count { get; set; }

        /// <summary>
        /// 活跃度 ->1 活跃 2 不活跃
        /// </summary>
        [Column("lic_activity")]
        public int lic_activity { get; set; }
    }
}