﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Siger.WeComApi.Core.Dto
{
    public class ProjectDto
    {
        /// <summary>
        /// 项目id
        /// </summary>
        public int Id { get; set; }

        /// <summary>
        /// 项目名称
        /// </summary>
        public string Title { get; set; }

        /// <summary>
        /// 项目描述
        /// </summary>
        public string Description { get; set; }

        /// <summary>
        /// 创建者 mid 与 _user id 对应
        /// </summary>
        public int Mid { get; set; }

        /// <summary>
        /// 企业 ID 与 _company id 对应
        /// </summary>
        public string CompanyId { get; set; }

        /// <summary>
        /// 创建日期
        /// </summary>
        public int Createtime { get; set; }

        /// <summary>
        /// 创建IP
        /// </summary>
        public string IP { get; set; }

        /// <summary>
        /// 项目负责人 id 与 _user id 对应
        /// </summary>
        public int Dutymid { get; set; }

        /// <summary>
        /// 负责该项目的销售 mid 与 _user id 对应
        /// </summary>
        public int salesmid { get; set; }

        /// <summary>
        /// 供应商 id 与 _supplier id 对应 作废
        /// </summary>
        public int Supplierid { get; set; }

        /// <summary>
        /// 初步报价
        /// </summary>
        public int Initialquotation { get; set; }

        /// <summary>
        /// 最终报价
        /// </summary>
        public int Finaloffer { get; set; }

        /// <summary>
        /// 项目类型 与 _project_type id 对应
        /// </summary>
        public int TypeId { get; set; }

        /// <summary>
        /// 进度 作废
        /// </summary>
        public System.Byte Progress { get; set; }

        /// <summary>
        /// 1有效 0无效
        /// </summary>
        public int Status { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public string Logo { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public string Modular { get; set; }

        /// <summary>
        /// 语言类型:0=>中文,1=>英文
        /// </summary>
        public int Language { get; set; }

        /// <summary>
        /// dashboard
        /// </summary>
        public string Dashboard_ids { get; set; }
    }
}
