﻿using System.ComponentModel.DataAnnotations;
using Siger.WeComApi.Common.Enums;
using Siger.WeComApi.Core.Enum;


namespace Siger.WeComApi.Core.Dto.Request
{
    public class RequestAddMachine
    {
        [Required(ErrorMessage = "TitleIsEmpty")]
        public string title { get; set; }

        [Required(ErrorMessage = "CodeIsEmpty")]
        public string code { get; set; }

        public string model { get; set; }

        public string factory { get; set; }

        public string factory_code { get; set; }

        public string made_date { get; set; }

        [Required(ErrorMessage = "TypeIsEmpty")]
        public string typeid { get; set; }

        public string image { get; set; }

        public int sectionid { get; set; }

        [Required(ErrorMessage = "MachineTypeNull")]
        public MachineAttributeType attribute { get; set; }
        [Required(ErrorMessage = "MachineAttributionNull")]
        public MachineAttributionEnum attribution { get; set; }


        public string tool_count { get; set; }

        public string machinelevel { get; set; }

        public string mid { get; set; }

        public string category { get; set; }


        //拓展字段

        /// <summary>
        /// Machine Name
        /// </summary>
        public string machine_name { get; set; } = string.Empty;

        /// <summary>
        /// 测试应用产品
        /// </summary>
        public string typical_application { get; set; } = string.Empty;

        /// <summary>
        /// 尺寸-内径
        /// </summary>
        public string inside_diameter { get; set; } = string.Empty;

        /// <summary>
        /// 尺寸-外径
        /// </summary>
        public string outside_diameter { get; set; } = string.Empty;

        /// <summary>
        /// 径向载荷
        /// </summary>
        public string radial_load { get; set; } = string.Empty;

        /// <summary>
        /// 轴向载荷
        /// </summary>
        public string axial_load { get; set; } = string.Empty;

        /// <summary>
        /// 压力
        /// </summary>
        public string pressure { get; set; } = string.Empty;

        /// <summary>
        /// 转速
        /// </summary>
        public string speed { get; set; } = string.Empty;

        /// <summary>
        /// 温度
        /// </summary>
        public string temperature { get; set; } = string.Empty;

        /// <summary>
        /// 转向
        /// </summary>
        public string rotation { get; set; } = string.Empty;

        /// <summary>
        /// 样本润滑
        /// </summary>
        public string sample_lubrication { get; set; } = string.Empty;

        /// <summary>
        /// 设备用油-润滑
        /// </summary>
        public string oil_lubrication { get; set; } = string.Empty;

        /// <summary>
        /// 设备用油-液压
        /// </summary>
        public string oil_hydraulic { get; set; } = string.Empty;

        /// <summary>
        /// 信号采集
        /// </summary>
        public string signal_monitor { get; set; } = string.Empty;

        /// <summary>
        /// 测试工位
        /// </summary>
        public string position { get; set; } = string.Empty;

        /// <summary>
        /// 设备尺寸
        /// </summary>
        public string machine_size { get; set; } = string.Empty;

        /// <summary>
        /// 设备简称
        /// </summary>
        public string machine_shortname { get; set; } = string.Empty;

        /// <summary>
        /// 负责人
        /// </summary>
        public string responsor { get; set; } = string.Empty;


        public int sorting { get; set; }
    }

    public class RequestUpdateMachine : RequestAddMachine
    {
        public int machineid { get; set; }
    }

    public class RequestGetMachineIdByCode
    {
        public string code { get; set; }
    }
    public class RequestCheckMachine
    {
        public string code { get; set; }
        public string name { get; set; }
        public int id { get; set; }
    }
}

