﻿using Siger.WeComApi.Common.cache;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace Siger.Middlelayer.Redis
{
    public partial class RedisCache
    {
        private const string ModuleSettingHash = "ModuleSetting";

        public async Task<IEnumerable<string>> GetModules(string key)
        {
            var models = new List<string>();
            var value = await CacheUtility.Instance.GetHashAsync(ModuleSettingHash, key);
            if (!string.IsNullOrWhiteSpace(value))
            {
                models.AddRange(value.Split(',').Select(module => module.ToLower()));
            }
            else //默认只有刀具
            {
                models.Add("tms");
            }
            return models;
        }
    }
}
