﻿using System.ComponentModel;

namespace Siger.WeComApi.Common.Enums.FieldEnum
{
    /// <summary>
    /// 月报发送周期
    /// </summary>
    public enum MonthReportCycle
    {
        Day = 1,

        Week,

        Month
    }

    public enum ReportTemplate
    {
        [Description("主模板")]
        MainReport = 0,
        //[Description("生产管理月报")]
        //ProductionManagement = 1,

        //[Description("效率分析月报")]
        //EfficiencyAnalysis,

        //[Description("综合月报")]
        //Comprehensive,

        //[Description("产量产出月报")]
        //YieldReport,
        //[Description("设备总体运行状况")] //新增
        //MachineRunning = 5,
        //[Description("设备报警分析")]
        //MachineAlarm = 6,
        [Description("设备综合效率分析")]
        MachineOEE = 1,
        [Description("设备切片分析")]
        MachineSplit = 2,
        [Description("设备稼动率")]
        MachineCrop = 3,
        [Description("生产效率")]
        Productivity = 4,
        [Description("设备产出统计")]
        MachineOfProductivity = 5,
        [Description("停机状态产出统计")]
        MachineStateOfStop = 6,
        /// <summary>
        /// FJW 客制化
        /// </summary>
        [Description("综合月报")]
        FJWCustomization = 7,
        /// <summary>
        /// 生产管理日报
        /// </summary>
        [Description("生产管理日报")]
        ProductionManagementDaily = 8,

        /// <summary>
        /// 系统使用率统计
        /// </summary>
        [Description("系统使用率统计")] //SKF
        UtilizationComm = 13,

        /// <summary>
        /// 其他备件库存
        /// </summary>
        [Description("其他备件库存")]
        TpmOtherSpareParts = 14,

        /// <summary>
        /// 生产日报&月报
        /// </summary>
        [Description("生产日报&月报")]
        ProductionDailyOrMonth = 15,
    }
}
