﻿
using System;
using System.Collections.Generic;
using System.Text;

namespace Siger.WeComApi.Common.ExcelImport
{
    public class ExportBadDecisionRecordList:ImportBase
    {
        /// <summary>
        /// 处理方式 1=>单件 2=>批量
        /// </summary>
        [ExcelColumn("处理方式")]
        public string ProcessModeDesc { get; set; }

        /// <summary>
        /// 产品名称
        /// </summary>
        [ExcelColumn("产品名称")]
        public string ProductName { get; set; }

        /// <summary>
        /// 产品编号
        /// </summary>
        [ExcelColumn("产品编号")]
        public string ProductCode { get; set; }

        /// <summary>
        /// 工单号
        /// </summary>
        [ExcelColumn("工单号")]
        public string WorkCode { get; set; }

        /// <summary>
        /// 工令单号
        /// </summary>
        [ExcelColumn("工令单号")]
        public string OrderNumber { get; set; }

        /// <summary>
        /// 报工工序
        /// </summary>
        [ExcelColumn("报工工序")]
        public string ReportRoute { get; set; }

        /// <summary>
        /// 缺陷类型
        /// </summary>
        [ExcelColumn("缺陷类型")]
        public string DefectType { get; set; }

        /// <summary>
        /// 缺陷名称
        /// </summary>
        [ExcelColumn("缺陷名称")]
        public string DefectName { get; set; }

        /// <summary>
        /// 处理结果
        /// </summary>
        [ExcelColumn("处理结果")]
        public string DisposeTypeDesc { get; set; }

        /// <summary>
        /// Desc:处理数量
        /// Default:
        /// Nullable:False
        /// </summary>
        [ExcelColumn("处理数量")]
        public int ProcessCount { get; set; }

        /// <summary>
        /// 返工到工序
        /// </summary>
        [ExcelColumn("返工到工序")]
        public string ReworkRoute { get; set; }

        /// <summary>
        /// 处理人
        /// </summary>
        [ExcelColumn("处理人")]
        public string DisposeUser { get; set; }

        /// <summary>
        /// 处理时间desc
        /// </summary>
        public string DisposeTimeDesc { get; set; }

        /// <summary>
        /// 不良品号
        /// </summary>
        [ExcelColumn("不良品号")]
        public string BadNumber { get; set; }

        /// <summary>
        /// 返工单号
        /// </summary>
        [ExcelColumn("返工单号")]
        public string ReworkOrder { get; set; }
    }
}
