﻿

namespace Siger.WeComApi.Common.ExcelImport
{
    public class OQCCheckItemTemplate : ImportBase
    {
        [ExcelColumn("产品编号")]
        public string productid { get; set; }
        [ExcelColumn("工艺名称")]
        public string route { get; set; }
        [ExcelColumn("料号")]
        public string pn { get; set; }

        [ExcelColumn("生产线")]
        public string line { get; set; }

        [ExcelColumn("工站")]
        public string station  { get; set; }

        [ExcelColumn("项次")]
        [DonnetCreate]
        [DonnetValidate]
        public int seq { get; set; }

        [ExcelColumn("项目名称")]
        public string item { get; set; }

        [ExcelColumn("项目标准")]
        public string descr { get; set; }

        [ExcelColumn("O:打勾/V:填值")]
        public string checktype { get; set; }

        [ExcelColumn("最大值")]
        public string max { get; set; }

        [ExcelColumn("最小值")]
        public string min { get; set; }

        [ExcelColumn("版本")]
        public string version { get; set; }

        [ExcelColumn("维护人")]
        [DonnetCreate]
        [DonnetValidate]
        public string uid { get; set; }

        [ExcelColumn("维护时间")]
        [DonnetCreate]
        [DonnetValidate]
        public string transdatetime { get; set; }
    }

    public class OQCCheckItemList : OQCCheckItemTemplate
    {
        [ExcelColumn("序号")]
        [DonnetCreate]
        public int No { get; set; }
    }
}
