﻿

namespace Siger.WeComApi.Common.ExcelImport
{
    /// <summary>
    /// 刀位导入导出
    /// </summary>
    public class ToolLocationList : ImportBase
    {
        [ExcelColumn("序号")]
        [DonnetValidate]
        [DonnetCreate]
        public int No { get; set; }

        /// <summary>
        /// 设备编号
        /// </summary>
        [ExcelColumn("设备编号")]
        [EmptyValidate("MachineCodeIsEmpty")]
        public string Code { get; set; }

        /// <summary>
        /// 设备名称
        /// </summary>
        [ExcelColumn("设备名称")]
        [DonnetValidate]
        [DonnetCreate]
        public string Name { get; set; }

        /// <summary>
        /// 产品图纸号
        /// </summary>
        [ExcelColumn("产品图纸号")]
        [EmptyValidate("ProductDrawCodeIsEmpty")]
        public string DrawingCode { get; set; }

        /// <summary>
        /// 程序号
        /// </summary>
        [ExcelColumn("程序号")]
        [EmptyValidate("ProgramNoIsEmpty")]
        public string ProgramNo { get; set; }

        /// <summary>
        /// 主轴号
        /// </summary>
        [ExcelColumn("主轴号")]
        [EmptyValidate("SpindleNoIsEmpty")]
        public string SpindleNo { get; set; }

        /// <summary>
        /// 刀位号
        /// </summary>
        [ExcelColumn("刀位号")]
        [EmptyValidate("ToolLocationNameIsEmpty")]
        public string ToolLocationName { get; set; }

        /// <summary>
        /// 刀具图纸号
        /// </summary>
        [ExcelColumn("刀具图纸号")]
        [EmptyValidate("ToolDrawCodeIsEmpty")]
        public string ToolDrawingCode { get; set; }

        /// <summary>
        /// 额定寿命
        /// </summary>
        [ExcelColumn("额定寿命")]
        [EmptyValidate("RateLifeIsEmpty")]
        public string RateLife { get; set; }

        /// <summary>
        /// 刀具名称
        /// </summary>
        [ExcelColumn("刀具名称")]
        [DonnetValidate]
        [DonnetCreate]
        public string ToolName { get; set; }

        [ExcelColumn("是否刀片类")]
        public string ISToolType { get; set; }
        [ExcelColumn("寿命系数")]
        public double Coefficent { get; set; }
    }
}
