﻿using Microsoft.Extensions.DependencyInjection;
using Microsoft.Extensions.DependencyInjection.Extensions;

namespace Siger.WeComApi.Common.HttpClients
{
    /// <summary>
    /// 自定义Http扩展
    /// </summary>
    public static class CustomHttpClientExtensions
    {
        /// <summary>
        /// 注入HttpClient
        /// </summary>
        /// <param name="services"></param>
        /// <returns></returns>
        public static IServiceCollection AddCustomHttpClient(this IServiceCollection services)
        {
            services.AddHttpClient();
            services.TryAddTransient(typeof(GenericHttpClient<>));
            return services;
        }
    }
}
