using System;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;



namespace Siger.WeComApi.Core.Domain.Entity
{

    [Table("siger_project_machinetool_account")]
    public class ProjectMachinetoolAccountEntity : ConfigEntityBase
    {
        public  ProjectMachinetoolAccountEntity()
        {
            Status = 1;
            
        }

		/// <summary>
		/// 
		/// </summary>
        [Key]
        [Column("id")]
        public int Id { get; set; }
		/// <summary>
		/// 工厂的pid
		/// </summary>
        [Column("projectid")]
        public int Projectid { get; set; }
		/// <summary>
		/// 父级pid(渠道客户的pid)
		/// </summary>
        [Column("parent_projectid")]
        public int ParentProjectid { get; set; }
		/// <summary>
		/// 父级设备类型
		/// </summary>
        [Column("parent_machinetype")]
        public int ParentMachinetype { get; set; }
		/// <summary>
		/// 设备类型
		/// </summary>
        [Column("machine_type")]
        public int MachineType { get; set; }
		/// <summary>
		/// 机床序列号
		/// </summary>
        [Column("machine_serialnum")]
        public string MachineSerialnum { get; set; }
		/// <summary>
		/// 盒子编号
		/// </summary>
        [Column("box_number")]
        public string BoxNumber { get; set; }
		/// <summary>
		/// 控制系统型号
		/// </summary>
        [Column("controller_model")]
        public string ControllerModel { get; set; }
		/// <summary>
		/// 创建人
		/// </summary>
        [Column("creator")]
        public int Creator { get; set; }
		/// <summary>
		/// 创建时间
		/// </summary>
        [Column("create_time")]
        public DateTime CreateTime { get; set; }
		/// <summary>
		/// (1已联网 2未联网)
		/// </summary>
        [Column("network_status")]
        public int NetworkStatus { get; set; }
		/// <summary>
		/// 
		/// </summary>
        [Column("status")]
        public int Status { get; set; }
		/// <summary>
		/// 渠道客户cid
		/// </summary>
        [Column("parent_cid")]
        public int ParentCid { get; set; }
		/// <summary>
		/// 修改人
		/// </summary>
        [Column("updator")]
        public int Updator { get; set; }
		/// <summary>
		/// 修改时间
		/// </summary>
        [Column("update_time")]
        public DateTime UpdateTime { get; set; }
		/// <summary>
		/// 设备id
		/// </summary>
        [Column("machineid")]
        public int Machineid { get; set; }

		/// <summary>
		/// 设备联网时间
		/// </summary>
		[Column("network_time")]
        public DateTime? NetworkTime { get; set; }

    }

}
