﻿using System.ComponentModel.DataAnnotations;

namespace Siger.WeComApi.Core.Dto.Request
{
    /// <summary>
    /// 企业信息参数
    /// </summary>
    public class RequestAddCompany
    {
        /// <summary>
        /// 企业中文名称
        /// </summary>
        [Required(ErrorMessage = "ChinesenameIsEmpty")]
        public string chinesename { get; set; }
        /// <summary>
        /// 企业名称拼音
        /// </summary>
        public string chinesepinyin { get; set; }
        /// <summary>
        /// 省
        /// </summary>
        [Required(ErrorMessage = "ProvinceIsEmpty")]
        public string province { get; set; }
        /// <summary>
        /// 市
        /// </summary>
        public string city { get; set; }
        /// <summary>
        /// 区
        /// </summary>
        public string county { get; set; }
        /// <summary>
        /// 具体地址
        /// </summary>
        [Required(ErrorMessage = "DetailaddressIsEmpty")]
        public string detailaddress { get; set; }
        /// <summary>
        /// 行业类别1
        /// </summary>
        public string industry_first { get; set; }
        /// <summary>
        /// 行业类别2
        /// </summary>
        public string industry_second { get; set; }
        /// <summary>
        /// 联系电话
        /// </summary>
        [Required(ErrorMessage = "TelephoneIsEmpty")]
        public string telephone { get; set; }
        /// <summary>
        /// 网址
        /// </summary>
        public string website { get; set; }
        /// <summary>
        /// 邮箱
        /// </summary>
        [Required(ErrorMessage = "CompanyEmailIsEmpty")]
        public string email { get; set; }
        /// <summary>
        /// 图片
        /// </summary>
        public string litpic { get; set; }
        /// <summary>
        /// 描述
        /// </summary>
        public string description { get; set; }
        /// <summary>
        /// 营业执照
        /// </summary>
        public string companycode { get; set; }
        /// <summary>
        /// 是否认证
        /// </summary>
        public string identification { get; set; }
        /// <summary>
        /// 联系人
        /// </summary>
        [Required(ErrorMessage = "ContactIsEmpty")]
        public string contact { get; set; }
        /// <summary>
        /// 创建时间
        /// </summary>
        public string create_time { get; set; }
        /// <summary>
        /// 企业id
        /// </summary>
        public int cid { get; set; }
        /// <summary>
        /// 维度
        /// </summary>
        public double lat { get; set; }
        /// <summary>
        /// 经度
        /// </summary>
        public double lon { get; set; }

        /// <summary>
        /// 企业类型(1渠道用户 2终端用户)
        /// </summary>
        public int CompanyType { get; set; } = 2;
    }

    /// <summary>
    /// 修改企业信息的传入参数
    /// </summary>
    public class RequestUpdateCompany : RequestAddCompany
    {
        /// <summary>
        /// 企业id
        /// </summary>
        [Required(ErrorMessage = "CompanyIdIsEmpty")]
        public int id { get; set; }
    }
}
