﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;
using System.Threading.Tasks;
using Microsoft.EntityFrameworkCore;
using Siger.Middlelayer.CncRepository.Response;
using Siger.WeComApi.Core.Domain.Entity;
using Siger.WeComApi.Core.Domain;
using Siger.WeComApi.Repository;
using Siger.WeComApi.Repository.Repositories;
using Siger.WeComApi.Common.Enums;
using Siger.WeComApi.Core.Domain.Data;
using Siger.WeComApi.Core.Dto.Response;
using Siger.WeComApi.Core.Domain.BigData.Models;
using Siger.WeComApi.Core.Enum.ModuleEnum;
using Siger.WeComApi.Repository.Extensions;
using Siger.WeComApi.Core.Domain.BigData.ResultData;
using Siger.WeComApi.Common.Enums.Extensions;
using Siger.WeComApi.Common.cache;

namespace Siger.Middlelayer.Repository.Repositories
{
    internal abstract class ApiConfigRepositoryBase<TEntity> : RepositoryBase<TEntity> where TEntity : ConfigEntityBase
    {
        /// <summary>
        /// 主库,写操作
        /// </summary>
        protected new readonly BaseDataDbContext DbMaster;

        /// <summary>
        /// 从库,读操作
        /// </summary>
        protected new readonly BaseDataReadDbContext DbSlave;
        protected ApiConfigRepositoryBase(BaseDataDbContext dbMaster, BaseDataReadDbContext dbSlave) : base(dbMaster, dbSlave)
        {
            this.DbMaster = dbMaster;
            this.DbSlave = dbSlave;
        }

        public int GetProjectLanguage(int projectId)
        {
            var project = DbSlave.siger_project.FirstOrDefault(t => t.id == projectId);
            return project?.language ?? 0;
        }

        #region 获取层级数据
        private string sectionKey = "ConfigSectionCache";

        public bool RemoveSectionCache(int projectId)
        {
            return RunAsnc.RemoveKey($"{sectionKey}_{projectId}");
        }
        public List<siger_project_level_section> GetSectionTreeInfos(int projectId)
        {
            Func<List<siger_project_level_section>> func = () =>
            {
                List<siger_project_level_section> finalSections = new List<siger_project_level_section>();
                var items = DbSlave.siger_project_level_section.Where(p => p.status == 1 && p.projectid == projectId).ToList();
                if (items != null && items.Count > 0)
                {
                    var roots = items.Where(p => p.parentid == 0).ToList();
                    if (roots != null && roots.Count > 0)
                    {
                        foreach (siger_project_level_section item in roots)
                        {
                            var actItem = loopProjectLevelSection(items, item, item.id);
                            finalSections.Add(actItem);
                        }
                    }
                }
                else
                {
                }
                return finalSections;
            };
            var list = RunAsnc.GetListInfo<siger_project_level_section>($"{sectionKey}_{projectId}", func);
            if (list != null && list.Count > 0)
            {
                return list;
            }
            return new List<siger_project_level_section>();
        }

        private void loopGetAllSection(siger_project_level_section root, List<siger_project_level_section> sectionFinal)
        {
            sectionFinal.Add(root);
            if (root.isHasChild)
            {
                foreach (var item in root.sectionChildren)
                {
                    loopGetAllSection(item, sectionFinal);
                }
            }
        }

        private void LoopAllChild(List<siger_project_level_section> allSection, ref string loopFinalIds, string loopIds, List<siger_project_level_section> childSections, siger_project_level_section rootsection)
        {
            if (rootsection.isHasChild)
            {
                foreach (var item in rootsection.sectionChildren)
                {
                    allSection.Add(item);
                    if (childSections.Any(p => p.id == item.id))
                    {
                        loopIds += ";" + item.id.ToString();
                        loopFinalIds = loopIds;
                        return;
                    }
                    else
                    {
                        LoopAllChild(allSection, ref loopFinalIds, loopIds + ";" + item.id.ToString(), childSections, item);
                    }
                }
            }
        }

        private List<siger_project_level_section> GetParentSections(List<siger_project_level_section> sectionAll, List<siger_project_level_section> childSections)
        {
            List<siger_project_level_section> newAllSection = new List<siger_project_level_section>();
            List<string> newStrSection = new List<string>();
            List<siger_project_level_section> finalSection = new List<siger_project_level_section>();
            foreach (var item in sectionAll)
            {
                newAllSection.Add(item);
                var strLoopIds = "";
                if (!childSections.Any(p => p.id == item.id))
                {
                    LoopAllChild(newAllSection, ref strLoopIds, item.id.ToString(), childSections, item);
                }
                if (!string.IsNullOrEmpty(strLoopIds))
                {
                    newStrSection.Add(strLoopIds);
                }

                if (newStrSection.Count == childSections.Count)
                {
                    break;
                }
            }
            if (newStrSection.Count > 0)
            {
                Dictionary<string, int> dict = new Dictionary<string, int>();
                foreach (var item in newStrSection)
                {
                    var items = item.Split(';').ToList();
                    foreach (var itemKey in items)
                    {
                        if (!dict.ContainsKey(itemKey))
                        {
                            dict.Add(itemKey, int.Parse(itemKey));
                        }
                    }
                }
                foreach (var itemSection in newAllSection)
                {
                    if (dict.Values.Contains(itemSection.id))
                    {
                        finalSection.Add(itemSection);
                    }
                }
            }
            return finalSection;
        }

        private void loopGetSectionAllChildren(siger_project_level_section root, List<siger_project_level_section> sections, IEnumerable<int> sectionIds)
        {
            if (sectionIds.Contains(root.id))
            {
                sections.Add(root);
            }
            else
            {
                if (root.isHasChild)
                {
                    foreach (var item in root.sectionChildren)
                    {
                        loopGetSectionAllChildren(item, sections, sectionIds);
                    }

                }
            }
        }

        private List<siger_project_level_section> GetCacheParentSections(int sectionId, int projectId)
        {
            return GetCacheParentSections(new List<int>() { sectionId }, projectId);
        }

        private List<siger_project_level_section> GetCacheParentSections(IList<int> sectionIds, int projectId)
        {
            List<siger_project_level_section> sections = GetSectionTreeInfos(projectId);
            List<siger_project_level_section> newSectAll = new List<siger_project_level_section>();
            if (sections != null)
            {
                foreach (var item in sections)
                {
                    loopGetSectionAllChildren(item, newSectAll, sectionIds);
                }
            }
            var parents = GetParentSections(sections, newSectAll);
            return parents;
        }

        public List<siger_project_level_section> GetCacheChildrenAndSelfSections(int sectionId, int projectId)
        {
            return GetCacheChildrenAndSelfSections(new List<int>() { sectionId }, projectId);
        }

        private List<siger_project_level_section> GetCacheChildrenAndSelfSections(IList<int> sectionIds, int projectId)
        {
            List<siger_project_level_section> sections = GetSectionTreeInfos(projectId);
            List<siger_project_level_section> newSectAll = new List<siger_project_level_section>();
            if (sections != null)
            {
                foreach (var item in sections)
                {
                    loopGetSectionAllChildren(item, newSectAll, sectionIds);
                }
            }

            List<siger_project_level_section> newFinal = new List<siger_project_level_section>();
            if (newSectAll.Count > 0)
            {
                foreach (var item in newSectAll)
                {
                    loopGetAllSection(item, newFinal);
                }
            }

            return newFinal;
        }

        private List<siger_project_level_section> GetCacheCurrentSections(IList<int> sectionIds, int projectId)
        {
            List<siger_project_level_section> sections = GetSectionTreeInfos(projectId);
            List<siger_project_level_section> newSectAll = new List<siger_project_level_section>();
            if (sections != null)
            {
                foreach (var item in sections)
                {
                    loopGetSectionAllChildren(item, newSectAll, sectionIds);
                }
            }

            List<siger_project_level_section> newFinal = new List<siger_project_level_section>();
            if (newSectAll.Count > 0)
            {
                foreach (var item in newSectAll)
                {
                    loopGetAllSection(item, newFinal);
                }
            }
            var parents = GetParentSections(sections, newSectAll);
            newFinal.AddRange(parents);

            return newFinal;
        }
        #endregion
        private siger_project_level_section loopProjectLevelSection(List<siger_project_level_section> allData, siger_project_level_section rootSection, int rootId)
        {
            var childrens = allData.Where(p => p.parentid == rootSection.id).ToList();
            if (childrens == null || childrens.Count == 0)
            {
                if (rootSection.rootId != rootId)
                {
                    rootSection.rootId = rootId;
                }
            }
            else
            {
                rootSection.sectionChildren = new List<siger_project_level_section>();
                foreach (var item in childrens)
                {
                    var actItem = loopProjectLevelSection(allData, item, rootId);
                    rootSection.sectionChildren.Add(actItem);
                    rootSection.rootId = rootId;
                }
            }
            return rootSection;
        }


        public IEnumerable<int> GetLevelSectionIds(int id, int projectid)
        {
            var list = new List<int>();
            //var query = GetSonLevelSections(id, projectid);

            //list.Add(id);
            //foreach (var section in query.ToList())
            //{
            //    list.Add(section.id);
            //}
            if(id==0)
            {
                return DbSlave.siger_project_level_section.Where(s=>s.projectid==projectid).Select(t => t.id).ToList();
            }


            var listSection = GetCacheChildrenAndSelfSections(id, projectid);
            if (listSection != null && listSection.Count > 0)
            {
                list = listSection.Select(p => p.id).ToList();
            }
            return list;
        }


        public IEnumerable<string> GetLevelSectionTitles(int id, int projectid)
        {
            var list = new List<string>();
            //var query = GetParentLevelSections(id, projectid);

            //foreach (var section in query.ToList().OrderBy(q => q.levelid))
            //{
            //    list.Add(section.title);
            //}
            var listSection = GetCacheParentSections(id, projectid);
            if (listSection != null && listSection.Count > 0)
            {
                foreach (var section in listSection.OrderBy(q => q.levelid))
                {
                    list.Add(section.title);
                }
            }

            return list;
        }

        public IEnumerable<siger_project_level_section> GetParentLevelSections(int ids, int projectid)
        {
            //var query = from c in _context.siger_project_level_section
            //            where c.id == id && c.projectid == projectid && c.status == (int)RowState.Valid
            //            select c;
            //return query.ToList().Concat(query.ToList().SelectMany(t => GetParentLevelSections(t.parentid, projectid)));

            var listSection = GetCacheParentSections(ids, projectid);
            return listSection;

        }

        public IEnumerable<siger_project_level_section> GetParentLevelSections(List<int> id, int projectid)
        {
            //var query = from c in _context.siger_project_level_section
            //            where c.id == id && c.projectid == projectid && c.status == (int)RowState.Valid
            //            select c;
            //return query.ToList().Concat(query.ToList().SelectMany(t => GetParentLevelSections(t.parentid, projectid)));

            var listSection = GetCacheParentSections(id, projectid);
            return listSection;

        }

        public IEnumerable<int> GetLevelSectionMachineIds(int id, int projectid)
        {
            //var list = new List<int>();
            //var query = GetSonLevelSections(id, projectid);

            //list.Add(id);
            //foreach (var section in query.ToList())
            //{
            //    list.Add(section.id);
            //}
            var list = GetLevelSectionIds(id, projectid);

            var querylist = from q in DbSlave.siger_project_machine_attribution
                            join m in DbSlave.siger_project_machine on q.machine equals m.id into ma
                            from m in ma.DefaultIfEmpty()
                            where list.Contains(q.station) && q.status == (int)RowState.Valid &&
                                  m.status == (int)RowState.Valid
                                  && m.projectid == projectid
                            orderby m.sorting
                            select q.machine;

            return querylist.ToList();
        }

        public async Task<List<siger_project_machine_attribution>> GetProjectLevelSectionMachineAttr(int id, int projectid)
        {
            var list = GetLevelSectionIds(id, projectid);

            var querylist = from q in DbSlave.siger_project_machine_attribution
                            join m in DbSlave.siger_project_machine on q.machine equals m.id into ma
                            from m in ma.DefaultIfEmpty()
                            where list.Contains(q.station) && q.status == (int)RowState.Valid &&
                                  m.status == (int)RowState.Valid
                                  && m.projectid == projectid
                            orderby m.sorting
                            select q;

            return await querylist.ToListAsync();
        }

        public IEnumerable<LevelSectionTree> GetLevelSectionMachines(int projectid)
        {
            var list = new List<LevelSectionTree>();
            var query = GetSonLevelSections(0, projectid);

            foreach (var section in query.ToList())
            {
                list.Add(new LevelSectionTree { id = section.id, name = section.title, pid = section.parentid, open = true });
            }

            var querylist = from q in DbSlave.siger_project_machine_attribution
                            join m in DbSlave.siger_project_machine on q.machine equals m.id into ma
                            from m in ma.DefaultIfEmpty()
                            where list.Select(s => s.id).Contains(q.station) && q.status == (int)RowState.Valid &&
                                  m.status == (int)RowState.Valid
                                  && m.projectid == projectid
                            orderby m.sorting
                            select new LevelSectionTree
                            {
                                id = m.id,
                                name = m.title,
                                pid = q.station,
                            };
            foreach (var levelSectionTree in querylist.ToList())
            {
                list.Add(new LevelSectionTree { id = levelSectionTree.id, name = levelSectionTree.name, pid = levelSectionTree.pid, open = true });
            }

            return list;
        }

        public IEnumerable<siger_project_level_section> GetSonLevelSections(int parentId, int projectid)
        {
            if (parentId == 0)
            {
                return GetAllSections(projectid);
            }
            //var query = (from c in _context.siger_project_level_section
            //             where c.id == parentId && c.projectid == projectid && c.status == (int)RowState.Valid
            //             select c).FirstOrDefault();
            //if (query != null && query.parentid == 0)
            //{
            //    //return GetAllSections(projectid);
            //    return GetSonLevelSectionsLop(query.id, projectid);
            //}
            //return GetSonLevelSections(parentId, GetAllSections(projectid));

            return GetCacheChildrenAndSelfSections(parentId, projectid);        }

        private IEnumerable<siger_project_level_section> GetSonLevelSectionsLop(int parentId, int projectid)
        {
            var query = from c in DbSlave.siger_project_level_section
                        where c.parentid == parentId && c.projectid == projectid && c.status == (int)RowState.Valid
                        select c;

            return query.ToList().Concat(query.ToList().SelectMany(t => GetSonLevelSectionsLop(t.id, projectid)));
        }

        private IEnumerable<siger_project_level_section> GetSonLevelSections(int parentId, List<siger_project_level_section> sectionList)
        {
            var query = sectionList.Where(f => f.parentid == parentId);
            return query.ToList().Concat(query.ToList().SelectMany(t => GetSonLevelSections(t.id, sectionList)));
        }

        private List<siger_project_level_section> GetAllSections(int projectid)
        {
            return DbSlave.siger_project_level_section.Where(q => q.projectid == projectid && q.status == (int)RowState.Valid).AsNoTracking().ToList();
        }

        public IEnumerable<siger_project_level_section> GetLevelSections(int id, int projectid)
        {
            var list = new List<siger_project_level_section>();
            //var query = GetSonLevelSections(id, projectid);

            //foreach (var section in query.ToList())
            //{
            //    list.Add(section);
            //}

            //var self = _context.siger_project_level_section.FirstOrDefault(q => q.id == id);
            //if (self != null && !list.Select(m => m.id).Contains(self.id))
            //{
            //    list.Add(self);
            //}
            var itemList = GetCacheChildrenAndSelfSections(id, projectid);
            if (itemList != null && itemList.Count > 0)
            {
                list = itemList;
            }
            return list;
        }

        public IEnumerable<ResponseKeyValue> GetDictKeyValues(int projectId, string key)
        {
            var result = new List<ResponseKeyValue>();
            var query = DbSlave.siger_tr_dict.Where(q =>
                q.projectId == projectId && q.cat == key && q.status == (int)RowState.Valid);
            if (query.Any())
            {
                foreach (var dict in query.ToList())
                {
                    result.Add(new ResponseKeyValue(dict.dkey, dict.dval));
                }
            }

            return result;
        }

        public IEnumerable<MachineData> GetLevelSectionMachines(int id, int projectid)
        {
            var list = new List<int>();
            var query = GetSonLevelSections(id, projectid);

            list.Add(id);
            foreach (var section in query.ToList())
            {
                list.Add(section.id);
            }

            var querylist = from q in DbSlave.siger_project_machine_attribution
                            join m in DbSlave.siger_project_machine on q.machine equals m.id
                            join se in DbSlave.siger_project_level_section on q.station equals se.id
                            where list.Contains(q.station) && q.status == (int)RowState.Valid &&
                                  m.status == (int)RowState.Valid && se.status == (int)RowState.Valid
                                  && m.projectid == projectid
                            orderby m.sorting, m.id
                            select new MachineData
                            {
                                //用于判断只要nc得
                                category = m.category,
                                section_id = q.station,
                                machine_id = m.id,
                                machine_name = m.title,
                                machine_code = m.code,
                                lastSectionTitle = se.title,
                                sorting = m.sorting
                            };

            return querylist.OrderBy(m => m.sorting).ToList();
        }

        public IEnumerable<MachineData> GetLevelSectionNames(int id, int projectid)
        {
            var list = new List<int>();
            var query = GetSonLevelSections(id, projectid);

            //list.Add(id);
            //foreach (var section in query.ToList())
            //{
            //    list.Add(section.id);
            //}
            if (query != null && query.Count() > 0)
            {
                list = query.Select(p => p.id).ToList();
            }

            var querylist = from q in DbSlave.siger_project_machine_attribution
                            join m in DbSlave.siger_project_machine on q.machine equals m.id into ma
                            from m in ma.DefaultIfEmpty()
                            join se in DbSlave.siger_project_level_section on q.station equals se.id
                            join se2 in DbSlave.siger_project_level_section on se.parentid equals se2.id
                            where list.Contains(q.station) && q.status == (int)RowState.Valid && m.attribution < 4
                            orderby m.sorting
                            select new MachineData
                            {
                                machine_id = m.id,
                                machine_name = m.title,
                                machine_code = m.code,
                                section_id = se.id,
                                lastSectionTitle = se.title,
                                lastSecondSectionTitle = se2.title,
                                sorting = m.sorting
                            };

            return querylist.OrderBy(m => m.sorting).ToList();
        }

        public IEnumerable<MachineData> GetLevelSectionNames(IEnumerable<int> machineIds, int projectid)
        {
            var querylist = from q in DbSlave.siger_project_machine_attribution
                            join m in DbSlave.siger_project_machine on q.machine equals m.id
                            join se in DbSlave.siger_project_level_section on q.station equals se.id
                            join se2 in DbSlave.siger_project_level_section on se.parentid equals se2.id
                            where machineIds.Contains(q.station) && q.status == (int)RowState.Valid &&
                                  m.status == (int)RowState.Valid && se.status == (int)RowState.Valid
                                  && m.projectid == projectid
                            select new MachineData
                            {
                                machine_id = m.id,
                                machine_name = m.title,
                                machine_code = m.code,
                                section_id = se.id,
                                lastSectionTitle = se.title,
                                lastSecondSectionTitle = se2.title,
                                sorting = m.sorting
                            };

            return querylist.OrderBy(m => m.sorting).ToList();
        }

        public siger_project_level_section GetLevelSection(int id, int projectid)
        {
            return DbSlave.siger_project_level_section.FirstOrDefault(t => t.id == id && t.projectid == projectid && t.status == (int)RowState.Valid);
        }

        public IEnumerable<siger_project_level_section> GetSecondLevelSection(int projectid)
        {
            var query = from q in DbSlave.siger_project_level_section
                        join qq in DbSlave.siger_project_level_section on q.id equals qq.parentid
                        where q.parentid == 0 && q.projectid == projectid
                        select qq;
            return query.AsEnumerable();
        }

        public siger_project_machine_attribution GetMachineAttributionByMachineId(int machineId)
        {
            return DbSlave.siger_project_machine_attribution.FirstOrDefault(t => t.machine == machineId && t.status == (int)RowState.Valid);
        }

        public IEnumerable<siger_project_level_section> GetParentSelfLevelSections(int parentid, int projectid)
        {
            //var query = from c in _context.siger_project_level_section
            //            where c.id == parentid && c.projectid == projectid && c.status == (int)RowState.Valid
            //            select c;

            //return query.ToList().Concat(query.ToList().SelectMany(t => GetParentLevelSections(t.parentid, projectid)));
            return GetCacheParentSections(parentid, projectid);
        }

        public IEnumerable<int> GetMachineIdsBySectionIds(IEnumerable<int> sectionIds, int projectid)
        {
            return from q in DbSlave.siger_project_machine_attribution
                   join m in DbSlave.siger_project_machine on q.machine equals m.id
                   where m.projectid == projectid && q.status == (int)RowState.Valid &&
                         m.status == (int)RowState.Valid && sectionIds.Contains(q.station)
                   select q.machine;
        }

        public IEnumerable<siger_project_level_section> GetLevelSectionsBySectionIds(IEnumerable<int> sectionIds, int projectid)
        {
            return DbSlave.siger_project_level_section.Where(t => sectionIds.Contains(t.id) && t.projectid == projectid && t.status == (int)RowState.Valid);
        }


        public IEnumerable<int> GetNCLevelSectionMachineIds(int id, int projectid)
        {
            var list = new List<int>();
            var query = GetSonLevelSections(id, projectid);

            //list.Add(id);
            //foreach (var section in query.ToList())
            //{
            //    list.Add(section.id);
            //}

            if (query != null && query.Count() > 0)
            {
                list = query.Select(p => p.id).ToList();
            }

            var querylist = from q in DbSlave.siger_project_machine_attribution
                            join m in DbSlave.siger_project_machine on q.machine equals m.id
                            where list.Contains(q.station) && q.status == (int)RowState.Valid &&
                                  m.status == (int)RowState.Valid && m.projectid == projectid && m.category == (int)MachineCategory.NC
                            orderby m.sorting, m.id
                            select q.machine;

            return querylist.ToList();
        }

        public IEnumerable<MachineData> GetNCLevelSectionNames(int id, int projectid,int machineAttrType)
        {
            ////list.Add(id);
            //foreach (var section in query.ToList())
            //{
            //    list.Add(section.id);
            //}


            var list = new List<int>();
            var query = GetSonLevelSections(id, projectid);


            var machineInfo = DbSlave.siger_project_machine.ToList();


            if (machineAttrType!=0) {

                machineInfo = DbSlave.siger_project_machine.Where(f=>f.attribute==machineAttrType).ToList();
            }

            
            if (query != null && query.Count() > 0)
            {
                list = query.Select(p => p.id).ToList();
            }

            var querylist = from q in DbSlave.siger_project_machine_attribution 
                            join m in machineInfo on q.machine equals m.id
                            join se in DbSlave.siger_project_level_section on q.station equals se.id
                            join se2 in DbSlave.siger_project_level_section on se.parentid equals se2.id
                            join se3 in DbSlave.siger_project_level_section on se2.parentid equals se3.id into ss
                            from se3 in ss.DefaultIfEmpty()
                            where list.Contains(se.id) && q.status == (int)RowState.Valid &&
                                  m.status == (int)RowState.Valid && se.status == (int)RowState.Valid && q.status == (int)RowState.Valid
                                  && m.projectid == projectid && m.category == (int)MachineCategory.NC 
                            orderby m.sorting, m.id
                            select new MachineData
                            {
                                machine_id = m.id,
                                machine_name = m.title,
                                machine_code = m.code,
                                section_id = se.id,
                                lastSectionTitle = se.title,
                                lastSecondSectionTitle = se3!=null?se3.title+" - "+ se2.title: se2.title,
                                reallastSecondSectionTitle=se2.title,
                                lastSecondSectionId = se.parentid,
                                sorting = m.sorting
                            };
            return querylist.OrderBy(q=>q.lastSecondSectionId).ThenBy(q=>q.sorting).ToList();
        }

        public IEnumerable<MachineData> GetNCLevelSectionNamesMachineTool(int projectId, int companyId, int factoryId, int parentMachineType, int machineType, string machineCode, string province, string city, string county)
        {
            var querylist = from p in DbSlave.ProjectMachinetoolAccountEntity
                            join m in DbSlave.siger_project_machine on p.Machineid equals m.id
                            join pt in DbSlave.siger_project_machine_type on p.ParentMachinetype equals pt.id
                            join st in DbSlave.siger_project_machine_type on p.MachineType equals st.id
                            join c in DbSlave.siger_project on m.projectid equals c.id
                            join q in DbSlave.siger_company on c.companyid.ToInt() equals q.id
                            where m.status == (int)RowState.Valid
                                  && p.ParentProjectid == projectId && m.category == (int)MachineCategory.NC
                                  && p.ParentCid == companyId
                            orderby m.sorting, m.id
                            select new MachineData
                            {
                                machine_id = m.id,
                                machine_name = m.title,
                                machine_code = m.code,
                                sorting = m.sorting,
                                ProjectId = p.Projectid,
                                CompanyId = c.companyid.ToInt(),
                                MachineModel = m.model,
                                MachineToolCode = p.MachineSerialnum,
                                County = q.county,
                                FactoryName = c.title,
                                ParentMachineType = p.ParentMachinetype,
                                MachineType = p.MachineType,
                                Province = q.province,
                                City = q.city,
                                ParentMachinetype = pt.title,
                                MachineTypeName = st.title,
                                MachineSerialnum = p.MachineSerialnum,
                                BoxNumber = p.BoxNumber,
                                ControllerModel = p.ControllerModel,
                                MachineTime = p.CreateTime,
                                NetworkTime = p.NetworkTime,
                                FactoryId = c.id
                            };

            Expression<Func<MachineData, bool>> factoryExpre = q => true;
            if (factoryId > 0)
            {
                factoryExpre = f => f.FactoryId == factoryId;
            }

            Expression<Func<MachineData, bool>> parentTypeExpre = q => true;
            if (parentMachineType>0)
            {
                parentTypeExpre = f => f.ParentMachineType == parentMachineType;
            }

            Expression<Func<MachineData, bool>> typeExpre = q => true;
            if (machineType > 0)
            {
                typeExpre = f => f.MachineType == machineType;
            }

            Expression<Func<MachineData, bool>> provinceExpre = q => true;
            if (!string.IsNullOrWhiteSpace(province))
            {
                provinceExpre = f => f.Province == province;
            }

            Expression<Func<MachineData, bool>> cityExpre = q => true;
            if (!string.IsNullOrWhiteSpace(city))
            {
                cityExpre = f => f.City == city;
            }

            Expression<Func<MachineData, bool>> machineCodeExpre = q => true;
            if (!string.IsNullOrWhiteSpace(machineCode))
            {
                machineCodeExpre = f => f.MachineToolCode.Contains(machineCode);
            }
            Expression<Func<MachineData, bool>> countyExpre = q => true;
            if (!string.IsNullOrWhiteSpace(county))
            {
                countyExpre = f => f.County == county;
            }

            var predicate = factoryExpre.And(parentTypeExpre).And(machineCodeExpre).And(countyExpre).And(typeExpre).And(provinceExpre).And(cityExpre);

            var entities = querylist.Where(predicate).AsNoTracking().ToList();

            return entities.OrderBy(q => q.sorting).ToList();
        }

        public IEnumerable<MachineData> GetNCLevelSectionMachines(int id, int projectid)
        {
            var list = new List<int>();
            var query = GetSonLevelSections(id, projectid);

            //list.Add(id);
            //foreach (var section in query.ToList())
            //{
            //    list.Add(section.id);
            //}
            if (query != null && query.Count() > 0)
            {
                list = query.Select(p => p.id).ToList();
            }

            var querylist = from q in DbSlave.siger_project_machine_attribution
                            join m in DbSlave.siger_project_machine on q.machine equals m.id
                            join se in DbSlave.siger_project_level_section on q.station equals se.id
                            where list.Contains(q.station) && q.status == (int)RowState.Valid &&
                                  m.status == (int)RowState.Valid && se.status == (int)RowState.Valid
                                  && m.projectid == projectid
                            select new MachineData
                            {
                                section_id = q.station,
                                machine_id = m.id,
                                machine_name = m.title,
                                machine_code = m.code,
                                lastSectionTitle = se.title,
                                sorting = m.sorting
                            };

            return querylist.OrderBy(q => q.sorting).ToList();
        }

        public IEnumerable<siger_project_level_section> GetNCLevelSections(int id, int projectid)
        {
            var res = new List<siger_project_level_section>();
            var result = DbSlave.siger_project_level
                .Where(f => f.status == RowState.Valid.GetHashCode() && f.projectid == projectid)
                .OrderBy(f => f.id).ToList();
            if (!result.Any())
            {
                return res;
            }
            var list = GetSonLevelSectionsByParentId(id, projectid, result).ToList();
            #region 将方法提炼出来，一次性请求出来
            var querylist = (from q in DbSlave.siger_project_machine_attribution
                             join m in DbSlave.siger_project_machine on q.machine equals m.id
                             where q.status == (int)RowState.Valid &&
                                   m.status == (int)RowState.Valid
                                   && m.projectid == projectid && m.category == (int)MachineCategory.NC
                             select new MachineData
                             {
                                 machine_id = m.id,
                                 machine_name = m.title,
                                 machine_code = m.code,
                                 section_id = q.station,
                             }).AsNoTracking().ToList();
            #endregion
            if (!list.Any())
            {
                return res;
            }
            var removeList = new List<int>();
            foreach (var sections in list)
            {
                if (removeList.Contains(sections.id))
                {
                    continue;
                }
                var deleteList = new List<int> { sections.id };
                var parentIds = new List<int> { sections.id };
                var i = 1;
                foreach (var level in result)
                {
                    if (sections.levelid <= level.id)
                    {
                        if (i == result.Count)
                        {
                            break;
                        }
                        var ids = parentIds;
                        parentIds = list.Where(t => ids.Contains(t.parentid)).Select(t => t.id).ToList();
                        deleteList.AddRange(parentIds);
                    }

                    i++;
                }

                //var machineIds = _context.siger_project_machine_attribution.Where(t =>
                //t.status == (int)RowState.Valid && parentIds.Contains(t.station)).Select(t => t.machine).ToList();
                //var machines = _context.siger_project_machine.Where(t =>
                //machineIds.Contains(t.id) && t.projectid == projectid && t.status == (int)RowState.Valid &&
                //t.category == (int)MachineCategory.NC);
                var machines = querylist.Where(f => parentIds.Contains(f.section_id));
                if (!machines.Any())
                {
                    removeList.AddRange(deleteList);
                }
            }
            list = list.Where(t => !removeList.Contains(t.id)).ToList();

            return list;
        }

        public IEnumerable<MachineData> GetNCLevelSectionNames(IEnumerable<int> machineIds, int projectid)
        {
            var querylist = from q in DbSlave.siger_project_machine_attribution
                            join m in DbSlave.siger_project_machine on q.machine equals m.id
                            join se in DbSlave.siger_project_level_section on q.station equals se.id
                            join se2 in DbSlave.siger_project_level_section on se.parentid equals se2.id
                            where machineIds.Contains(q.machine) && q.status == (int)RowState.Valid &&
                                  m.status == (int)RowState.Valid && se.status == (int)RowState.Valid
                                  && se2.status==(int)RowState.Valid
                                  && m.projectid == projectid && m.category == (int)MachineCategory.NC
                            select new MachineData
                            {
                                machine_id = m.id,
                                machine_name = m.title,
                                machine_code = m.code,
                                section_id = se.id,
                                lastSectionTitle = se.title,
                                lastSecondSectionTitle = se2.title,
                                sorting = m.sorting
                            };

            return querylist.OrderBy(q => q.sorting).ToList();
        }

        public List<int> GetNCLevelSectionMid(IEnumerable<int> machineIds, int projectid)
        {
            var querylist = from q in DbSlave.siger_project_machine_attribution
                            join m in DbSlave.siger_project_machine on q.machine equals m.id
                            where machineIds.Contains(q.machine) && q.status == (int)RowState.Valid &&
                                  m.status == (int)RowState.Valid
                                  && m.projectid == projectid && m.category == (int)MachineCategory.NC
                            select m.id;

            return querylist.ToList();
        }

        public IEnumerable<int> GetNCMachineIdsBySectionIds(IEnumerable<int> sectionIds, int projectid, bool dashboarSlicedata = false)
        {
            if (dashboarSlicedata)
            {
                return from q in DbSlave.siger_project_machine_attribution
                       join m in DbSlave.siger_project_machine on q.machine equals m.id
                       where m.projectid == projectid && q.status == (int)RowState.Valid &&
                             m.status == (int)RowState.Valid && sectionIds.Contains(q.station) && m.category == (int)MachineCategory.NC
                       orderby m.sorting, m.id
                       select q.machine;
            }
            return from q in DbSlave.siger_project_machine_attribution
                   join m in DbSlave.siger_project_machine on q.machine equals m.id
                   where m.projectid == projectid && q.status == (int)RowState.Valid &&
                         m.status == (int)RowState.Valid && sectionIds.Contains(q.station) && m.category == (int)MachineCategory.NC
                   orderby m.sorting, m.id
                   select q.machine;
        }
        /// <summary>
        /// 设备id重新排序
        /// </summary>
        /// <param name="sectionIds">设备id</param>
        /// <param name="projectid">项目id</param>
        /// <returns></returns>
        public IEnumerable<int> GetOrderByNCMachineIds(IEnumerable<int> sectionIds, int projectid)
        {
            return from m in DbSlave.siger_project_machine
                   where m.projectid == projectid && m.status == (int)RowState.Valid &&
                   sectionIds.Contains(m.id) && m.category == (int)MachineCategory.NC
                   orderby m.sorting, m.id
                   select m.id;
        }

        /// <summary>
        /// 设备id重新排序
        /// </summary>
        /// <param name="machineIds">设备id</param>
        /// <param name="projectid">项目id</param>
        /// <returns></returns>
        public IEnumerable<int> GetOrderByMachineIds(IEnumerable<int> machineIds, int projectid)
        {
            var querylist = from q in DbSlave.siger_project_machine_attribution
                            join m in DbSlave.siger_project_machine on q.machine equals m.id
                            join se in DbSlave.siger_project_level_section on q.station equals se.id
                            where m.projectid == projectid && q.projectid == projectid && se.projectid == projectid && m.status == (int)RowState.Valid && q.status == (int)RowState.Valid && se.status == (int)RowState.Valid
                            && machineIds.Contains(m.id) && m.category == (int)MachineCategory.NC
                            orderby se.parentid, m.sorting, m.id
                            select m.id;
            
            return querylist.ToList();
        }

        private IEnumerable<siger_project_level_section> GetSonLevelSectionsByParentId(int id, int projectid, IEnumerable<siger_project_level> levels)
        {
            var res = new List<siger_project_level_section>();
            if (id > 0)
            {
                var section = DbSlave.siger_project_level_section.FirstOrDefault(t =>
                    t.id == id && t.projectid == projectid && t.status == (int)RowState.Valid);
                if (section == null)
                {
                    return res;
                }
                res.Add(section);
            }

            var parentIds = new List<int> { id };
            foreach (var level in levels)
            {
                var sections = DbSlave.siger_project_level_section.Where(t =>
                    parentIds.Contains(t.parentid) && t.projectid == projectid && t.status == (int)RowState.Valid).ToList();
                if (sections.Any())
                {
                    res.AddRange(sections);
                    parentIds = sections.Select(t => t.id).ToList();
                }
            }

            return res;
        }
        /// <summary>
        /// 最后两级section Desc
        /// </summary>
        /// <param name="machineId"></param>
        /// <param name="projectId"></param>
        /// <returns></returns>
        public string GetLineLevelTitlebByMachine(int machineId, int projectId)
        {
            var query = from lm in DbSlave.siger_project_machine_attribution
                        join lv in DbSlave.siger_project_level_section on lm.station equals lv.id
                        join plv in DbSlave.siger_project_level_section on lv.parentid equals plv.id
                        where lv.projectid == projectId && lv.status == (int)RowState.Valid &&
                        lm.machine == machineId
                        select new LevelTitle
                        {
                            Lastlevel = lv.parentid,
                            LastTitle = lv.title,
                            PreLevel = plv.id,
                            PreTitle = plv.title
                        };
            var data = query.ToArray();
            var obj = data.FirstOrDefault();
            if (obj != null)
            {
                return obj.PreTitle + "-" + obj.LastTitle;
            }
            return machineId.ToString();
        }

        public string GetMachineLocationBySectionId(int sectionId, int projectId)
        {
            var titles = GetLevelSectionTitles(sectionId, projectId);
            return string.Join("-", titles);
        }

        public string GetMachineLocationByMachineId(int machineId, int projectId)
        {
            var section = DbSlave.siger_project_machine_attribution.FirstOrDefault(t =>
                t.machine == machineId && t.status == (int)RowState.Valid);
            if (section == null)
            {
                return "";
            }
            var titles = GetLevelSectionTitles(section.station, projectId);
            return string.Join("-", titles);
        }

        public IEnumerable<siger_project_machine_attribution> GetSonLevelMachineAttribution(int parentId, int projectid)
        {
            var query = from c in DbSlave.siger_project_machine_attribution
                        where c.parent == parentId && c.projectid == projectid && c.status == (int)RowState.Valid
                        select c;

            return query.ToList().Concat(query.ToList().SelectMany(t => GetSonLevelMachineAttribution(t.id, projectid)));
        }
        public IEnumerable<siger_project_machine_attribution> GetParentLevelAttribution(int id, int projectid)
        {
            var query = from c in DbSlave.siger_project_machine_attribution
                        where c.id == id && c.projectid == projectid && c.status == (int)RowState.Valid
                        select c;

            return query.ToList().Concat(query.ToList().SelectMany(t => GetParentLevelAttribution(t.parent, projectid)));
        }

        public IEnumerable<int> GetAttributionMachineIds(int id, int projectid)
        {
            var list = new List<int>();
            var query = GetSonLevelSections(id, projectid).ToList();
            if (!query.Any())
            {
                list.Add(id);
            }
            else
            {
                foreach (var section in query)
                {
                    list.Add(section.id);
                }
            }
            var querylist = from q in DbSlave.siger_project_machine_attribution
                            join m in DbSlave.siger_project_machine on q.machine equals m.id into ma
                            from m in ma.DefaultIfEmpty()
                            where list.Contains(q.station) && q.status == (int)RowState.Valid &&
                                  m.status == (int)RowState.Valid
                                  && m.projectid == projectid && m.attribution < 4
                            orderby m.sorting
                            select q.machine;

            return querylist.ToList();
        }
        public IEnumerable<int> GetAttributionMachineIdsByList(List<int> ids, int projectid)
        {
            var list = new List<int>();
            var query = GetCacheChildrenAndSelfSections(ids, projectid).ToList();
            if (!query.Any())
            {
                list.AddRange(ids);
            }
            else
            {
                foreach (var section in query)
                {
                    list.Add(section.id);
                }
            }
            var querylist = from q in DbSlave.siger_project_machine_attribution
                            join m in DbSlave.siger_project_machine on q.machine equals m.id into ma
                            from m in ma.DefaultIfEmpty()
                            where list.Contains(q.station) && q.status == (int)RowState.Valid &&
                                  m.status == (int)RowState.Valid
                                  && m.projectid == projectid && m.attribution < 4
                            orderby m.sorting
                            select q.machine;

            return querylist.ToList();
        }
        public IEnumerable<siger_project_machine> GetAttributionMachineList(int id, int projectid, List<int> attribution)
        {
            var list = new List<int>();
            var query = GetSonLevelSections(id, projectid).ToList();
            if (!query.Any())
            {
                list.Add(id);
            }
            else
            {
                foreach (var section in query)
                {
                    list.Add(section.id);
                }
            }
            var querylist = from q in DbSlave.siger_project_machine_attribution
                            join m in DbSlave.siger_project_machine on q.machine equals m.id into ma
                            from m in ma.DefaultIfEmpty()
                            where list.Contains(q.station) && q.status == (int)RowState.Valid &&
                                  m.status == (int)RowState.Valid
                                  && m.projectid == projectid && attribution.Contains(m.attribution)
                            orderby m.sorting
                            select m;

            return querylist.ToList();
        }

        public IEnumerable<siger_project_machine> GetAttributionMachineList(List<int> sections, int projectid, List<int> attribution)
        {
            var list = new List<int>();
            foreach (var section in sections)
            {
                var query = GetSonLevelSections(section, projectid).ToList();
                if (!query.Any())
                {
                    list.Add(section);
                }
                else
                {
                    foreach (var data in query)
                    {
                        list.Add(data.id);
                    }
                }
            }
            var querylist = from q in DbSlave.siger_project_machine_attribution
                            join m in DbSlave.siger_project_machine on q.machine equals m.id into ma
                            from m in ma.DefaultIfEmpty()
                            where list.Contains(q.station) && q.status == (int)RowState.Valid &&
                                  m.status == (int)RowState.Valid
                                  && m.projectid == projectid && attribution.Contains(m.attribution)
                            orderby m.sorting
                            select m;

            return querylist.ToList();
        }

        public string GetUserNamesByMids(string mids, int projectId)
        {
            var ids = mids.TrimEnd(',').Split(',').Distinct().ToList();
            var users = DbSlave.siger_project_user.Where(q =>
                ids.Contains(q.mid.ToString()) && q.status == (int)RowState.Valid && q.projectid == projectId).Select(m => m.name).ToList();
            if (users.Any())
            {
                return string.Join(",", users);
            }

            return string.Empty;
        }

        public bool GetMachineStateByMid(int mid, int projectId)
        {
            var machineList = DbSlave.siger_project_clock_record.Where(q => q.endtime < q.starttime && q.status == (int)RowState.Valid && q.projectid == projectId).Select(q => q.machine_id);
            if (machineList.Any())
            {
                if (machineList.Contains(mid))
                {
                    return true;
                }
            }
            var machines = DbSlave.siger_projectId_plan_machine_route.Where(q => q.machineId == mid && q.status != (int)RowState.Invalid && q.projectId == projectId).ToList();
            if (machines.Any())
            {
                return true;
            }
            return false;
        }

        public IDictionary<int, int> GetSectionByMachine(List<int> ids, int projectid)
        {
            IDictionary<int, int> dict = new Dictionary<int, int>();

            var query = DbSlave.siger_project_machine_attribution.Where(q => ids.Contains(q.machine) && q.status == (int)RowState.Valid && q.projectid == projectid).ToList();
            if (query != null)
            {
                foreach (var item in query)
                {
                    if (!dict.ContainsKey(item.machine))
                    {
                        dict.Add(item.machine, item.station);
                    }
                }
            }
            return dict;
        }

        public int GetSectionByMachine(int id, int projectid)
        {
            var section = 0;
            var query = DbSlave.siger_project_machine_attribution.Where(q => q.machine == id && q.status == (int)RowState.Valid && q.projectid == projectid).FirstOrDefault();
            if (query != null)
            {
                section = query.station;
            }
            return section;
        }

        public IEnumerable<CncDailySliceSate> GetsliceSates(IEnumerable<CncDailySliceSate> sliceSates, int machineId, int projectid, DateTime start, DateTime end)
        {
            if (sliceSates.Any())
            {
                var query = sliceSates.Where(q => q.machineID == machineId &&
                             (q.date >= start && q.date <= end)).ToList();
                return query;
            }

            return null;
        }

        public IEnumerable<CncSliceSate> GetsliceSates(IEnumerable<CncSliceSate> sliceSates, int machineId, int projectid, DateTime start, DateTime end)
        {
            if (sliceSates.Any())
            {
                var query = sliceSates.Where(q => q.MachineID == machineId &&
                             (q.StartTime >= start && q.EndTime <= end) ||
                             (q.StartTime < start && q.EndTime > start && q.EndTime <= end) ||
                             (q.StartTime >= start && q.StartTime < end && q.EndTime > end) ||
                             (q.StartTime < start && q.EndTime > end)).ToList();
                return query;
            }

            return null;
        }

        public IEnumerable<ResponseClockRecord> GetMachineuser(string machineId, int projectid)
        {
            var query = from a in DbSlave.siger_project_machine
                        join b in DbSlave.siger_project_machine_attribution on a.id equals b.machine
                        join c in DbSlave.siger_project_level_section on b.station equals c.id

                        where b.status == (int)RowState.Valid && b.projectid == projectid && a.id == machineId.ToInt()
                        select new ResponseClockRecord
                        {
                            id = a.id,
                            machinesolution = c.title,
                            machinename = b.name
                        };
            return query.ToList();

        }

        public IEnumerable<ResponseClockRecord> GetMachineuserByMid(int mid, int projectid)
        {
            var query = from a in DbSlave.siger_project_machine
                        join b in DbSlave.siger_project_machine_attribution on a.id equals b.machine
                        join c in DbSlave.siger_project_level_section on b.station equals c.id

                        where b.status == (int)RowState.Valid && b.projectid == projectid && a.id == mid
                        select new ResponseClockRecord
                        {
                            id = a.id,
                            machinesolution = c.title,
                            machinename = b.name
                        };
            return query.ToList();

        }

        /// <summary>
        /// 获取父级层级的名称和id
        /// </summary>
        /// <param name="id"></param>
        /// <param name="projectid"></param>
        /// <returns></returns>
        public (string, int) GetParentLevelNames(int id, int projectid)
        {
            (string, int) result = ("", 0);
            var querylist = from q in DbSlave.siger_project_level_section
                            join c in DbSlave.siger_project_level_section on q.parentid equals c.id
                            where q.id == id && q.status == (int)RowState.Valid && q.projectid == projectid && c.status == (int)RowState.Valid && c.projectid == projectid
                            select new { c.title, c.id };
            if (querylist != null && querylist.Count() > 0)
            {
                result = (querylist.FirstOrDefault().title, querylist.FirstOrDefault().id);
            }

            return result;
        }
    }
}
