﻿using System;
using System.Collections.Generic;
using System.IO;
using System.IO.Compression;
using System.Linq;
using System.Net;
using System.Text;
using System.Threading.Tasks;

namespace Siger.BaseDataApi.Schedule
{
    public class HttpRequestClient
    {
        public static string HttpRequest(string requestUriString, string requestData, int timeOut, string method = "POST", string encodName = "utf-8", string contentType = "text", Dictionary<string, string> headers = null)
        {
            try
            {
                Encoding encoding = Encoding.GetEncoding(encodName);
                requestUriString = (method == "GET" && !string.IsNullOrEmpty(requestData)) ? string.Format("{0}?{1}", requestUriString, requestData) : requestUriString;
                HttpWebRequest httpRequest = WebRequest.Create(requestUriString) as HttpWebRequest;
                httpRequest.Method = method;
                httpRequest.Timeout = timeOut;
                switch ((contentType ?? "").ToLower())
                {
                    case "xml": httpRequest.ContentType = string.Format("application/xml;charset={0}", encodName); break;
                    case "json":
                        if (headers != null)
                        {
                            if (headers.Count > 0)
                            {
                                foreach (var item in headers)
                                {
                                    httpRequest.Headers.Add(item.Key, item.Value);
                                }
                            }

                        }
                        httpRequest.ContentType = string.Format("application/json;charset={0}", encodName);


                        break;
                    case "text": httpRequest.ContentType = string.Format("application/x-www-form-urlencoded;charset={0}", encodName); break;
                    case "soap":
                        {
                            httpRequest.ContentType = string.Format("text/xml;charset={0}", encodName);
                            httpRequest.Headers.Add("SOAPAction", "");
                        }
                        break;
                    default: httpRequest.ContentType = null; break;
                }
                if (!string.IsNullOrEmpty(requestData) && method == "POST")
                {
                    byte[] dataArray = encoding.GetBytes(requestData);
                    httpRequest.ContentLength = dataArray.Length;
                    using (Stream stream = httpRequest.GetRequestStream())
                    {
                        stream.Write(dataArray, 0, dataArray.Length);
                    }
                }
                string responseMessage;
                using (HttpWebResponse httpResponse = (HttpWebResponse)httpRequest.GetResponse())
                {
                    if (httpResponse.ContentEncoding!=null && httpResponse.ContentEncoding.ToLower().Contains("gzip"))
                    {
                        using (GZipStream stream = new GZipStream(httpResponse.GetResponseStream(), CompressionMode.Decompress))
                        {
                            using (StreamReader reader = new StreamReader(stream))
                            {
                                responseMessage = reader.ReadToEnd();
                            }
                        }
                    }
                    else
                    {
                        using (Stream stream = httpResponse.GetResponseStream())
                        {
                            StreamReader reader = new StreamReader(stream, encoding);
                            responseMessage = reader.ReadToEnd();
                            reader.Close();
                        }
                    }
                }
                httpRequest.Abort();
                return responseMessage;
            }
            catch (Exception ex)
            {
                throw;
            }
        }
 }
}
