﻿using System;
using System.Collections.Generic;
using System.Text;
using System.ComponentModel;
namespace Siger.WeComApi.Core.Enum.ModuleEnum
{
    /// <summary>
    /// tool module, start from 6000000
    /// </summary>
    public enum ToolEnum
    {
        //  启动模块--枚举
        [Description("Tools服务配置加载失败")] LoadCfgFail = 6000000,
        [Description("Tools服务注册Consul失败")] RegConsulFail,
        [Description("质量异常")] Quality,
        [Description("计数寿命到")] ToolDieLine,
        [Description("磨损过度")]Wear,
        [Description("崩刃")]Broken,
        [Description("断刀")]Destroyed,
        [Description("无此选项")] NoItem,
        /// <summary>
        /// 单价范围起始不能大于结束
        /// </summary>
        [Description("单价范围起始不能大于结束")] PriceRangeError,

        
        [Description("无符合条件的原始数据")] NoData,
        [Description("无法连接mongodb数据库")] CanNotConnectToMongoDB,
        [Description("当前程序号未被监控")] TheProgramNotMonite,
        [Description("未给当前监控对象训练包络线")] NotTranining,
        [Description("步骤号异常")] ErrorStepNumber,
        [Description("当前无信号")] NoSignal,
        [Description("未知错误,错误代码")] Error,
        
        [Description("设备运行状态数据为空 请检查Job是否运行")]CNCSateNull,
        [Description("当前运行非加工程序")] NoProcessProgram,
        [Description("无加工记录")] CurrCycleLoad,
        [Description("没定义额定寿命")] RatedLife,
        [Description("调用计算脚本失败")] CallRserverErro,
        [Description("时间范围内无有效数据")] BLXUpdateFalse,
        [Description("获取原始数据失败")] ErrorPullHBase,
        [Description("选定条件下无完整加工周期工件")] NoWorkPiece,
        [Description("获取原始数据超时")] HBTimeOut,
        [Description("该时间内已存在其他标定")] ExitsTypeMark,
        [Description("寿命系数大于1")] CoefficentError=6000126,

    }

    public enum AlarmGrade
    {
        [Description("未设置")]
        Noconfig=-1,
        [Description("正常")]
        Normal = 0,
        /// <summary>
        /// 质量异常
        /// </summary>
        [Description("质量异常")]
        Quality = 1,
        /// <summary>
        /// 计数寿命到
        /// </summary>
        [Description("计数寿命到")]
        ToolDieLine ,
        /// <summary>
        /// 磨损过度
        /// </summary>
        [Description("磨损过度")]
        Wear ,
        /// <summary>
        /// 崩刃
        /// </summary>
        [Description("崩刃")]
        Broken ,
        /// <summary>
        /// 断刀
        /// </summary>
        [Description("断刀")]
        Destroyed,

        /// <summary>
        /// 负载大
        /// </summary>
        [Description("负载大")]
        Load,

        /// <summary>
        /// 换型
        /// </summary>
        [Description("换型")]
        ChangeMould,

        [Description("测试消息")]
        Test=99,

        [Description("自动换刀")]
        AutoChangeTool
    }
 
    public enum AlarmType
    {
        /// <summary>
        /// 三色灯
        /// </summary>
        [Description("三色灯")]
        Lamp,

        /// <summary>
        /// 报警记录弹出
        /// </summary>
        [Description("报警记录弹出")]
        AlarmDialog,

        /// <summary>
        /// PMC停机控制
        /// </summary>
        [Description("PMC停机控制")]
        PMC,

        /// <summary>
        /// PMC停机方式
        /// </summary>
        [Description("PMC停机方式")]
        ShutDownType
    }
    /// <summary>
    /// 控制线自学习
    /// </summary>
    public enum AutoStudy
    {
        /// <summary>
        /// 关闭控制线学习
        /// </summary>
        Close,
        /// <summary>
        /// 打开控制线学习
        /// </summary>
        Open
    }
    public enum PnType
    {
        Main = 1,
        Sub = 2
    }
    public enum Cutter_type
    {
        /// <summary>
        /// 新刀
        /// </summary>
        NewTool,
        /// <summary>
        /// 旧刀
        /// </summary>
        OldTool
    }
    public enum PowerStatu
    {
        [Description("否")]
        OFF,
        [Description("是")]
        ON
    }

    /// <summary>
    /// 刀具标定类型
    /// </summary>
    public enum ToolMarkType
    {
        /// <summary>
        /// 无配置 （包络线 上下限）
        /// </summary>
        NotMarkType = 0,
        /// <summary>
        /// 极限磨损
        /// </summary>
        UltimateWear,

        /// <summary>
        /// 轻微磨损
        /// </summary>
        LittleWear,

        /// <summary>
        /// 轻微崩刃
        /// </summary>
        LittleBroke,

        /// <summary>
        /// 严重崩刃
        /// </summary>
        SeriousBroke,

        /// <summary>
        /// 刀具断刀
        /// </summary>
        ToolBreak,

        /// <summary>
        /// 新刀标定  0：非刀片 1：刀片
        /// </summary>
        NewTool
    }
    public enum ToolType
    {

        /// <summary>
        /// 非刀片
        /// </summary>
        NOBlade,
        /// <summary>
        /// 刀片
        /// </summary>
        Blade,
    }
}
