﻿
using System;

namespace Siger.WeComApi.Common.ExcelImport
{
    public class SpotCheckList : ImportBase
    {
        [ExcelColumn("序号")]
        public int No { get; set; }
        [ExcelColumn("点检编号")]
        public string Code { get; set; }
        [ExcelColumn("点检类型")]
        public string CheckType { get; set; }
        [ExcelColumn("项目类型")]
        public string ItemType { get; set; }
        [ExcelColumn("单位")]
        public string Unit { get; set; }
        [ExcelColumn("执行周期")]
        public string Cycle { get; set; }
        [ExcelColumn("点检内容")]
        public string Content { get; set; }
        [ExcelColumn("创建人 ")]
        public string Creator { get; set; }
        [ExcelColumn("备注")]
        public string Remark { get; set; }
    }

    public class SpotCheckTemplate : ImportBase
    {
        [ExcelColumn("点检编号*")]
        public string Code { get; set; }
        [ExcelColumn("点检类型*")]
        public string CheckType { get; set; }
        [ExcelColumn("项目类型*")]
        public string ItemType { get; set; }
        [ExcelColumn("单位(*数值型必填)")]
        public string Unit { get; set; }
        [ExcelColumn("执行周期*")]
        public string Cycle { get; set; }
        [ExcelColumn("点检内容*")]
        public string Content { get; set; }
        [ExcelColumn("备注")]
        public string Remark { get; set; }
    }


    public class SpotCheckHistroyList : ImportBase
    {
        [ExcelColumn("序号")]
        public int No { get; set; }
        [ExcelColumn("点检时间")]
        public string CheckTime { get; set; }
        [ExcelColumn("点检编号")]
        public string Code { get; set; }
        [ExcelColumn("点检类型")]
        public string CheckType { get; set; }
        [ExcelColumn("点检内容")]
        public string Content { get; set; }
        [ExcelColumn("勾选确定值")]
        public string NormalValue { get; set; }
        [ExcelColumn("单位")]
        public string Unit { get; set; }
        [ExcelColumn("上限")]
        public string Max { get; set; }
        [ExcelColumn("下限 ")]
        public string Min { get; set; }
        [ExcelColumn("读值")]
        public string Value { get; set; }
        [ExcelColumn("点检结果")]
        public string Result { get; set; }
        [ExcelColumn("执行部门")]
        public string Department { get; set; }
        [ExcelColumn("执行人员")]
        public string User { get; set; }
        [ExcelColumn("备注")]
        public string Remark { get; set; }
    }
}
