﻿using Microsoft.AspNetCore.Mvc.Filters;
using Siger.CommonUtil.Logging.OperateLog;
using Siger.WeComApi.Common.Constants;
using Siger.WeComApi.Common.Helpers;
using System;
using System.Collections.Generic;
using System.Text;

namespace Siger.WeComApi.Common.Filter
{
    /// <summary>
    /// 操作日志Attribute
    /// </summary>
    [AttributeUsage(AttributeTargets.Method, AllowMultiple = false, Inherited = false)]
    public class OperationLogAttribute : ActionFilterAttribute
    {
        /// <summary>
        /// 模块
        /// </summary>
        private string module { get; }

        /// <summary>
        /// 操作
        /// </summary>
        private string operate { get; }

        /// <summary>
        /// 构造
        /// </summary>
        /// <param name="module"></param>
        /// <param name="operate"></param>
        public OperationLogAttribute(string module, string operate)
        {
            this.module = module;
            this.operate = operate;
        }

        /// <summary>
        /// 执行
        /// </summary>
        /// <param name="context"></param>
        public override void OnActionExecuted(ActionExecutedContext context)
        {
            var logModel = BuildOperateModel(context);
            OperateLogService.AddOperateLog(logModel);
            base.OnActionExecuted(context);
        }

        /// <summary>
        /// 构建操作模型
        /// </summary>
        /// <param name="context"></param>
        /// <returns></returns>

        private OperateLogModel BuildOperateModel(ActionExecutedContext context)
        {
            OperateLogModel logModel = new OperateLogModel(module, operate);
            AnalysisTokenValue(context, logModel);
            return logModel;
        }

        /// <summary>
        /// 解析tokenValue
        /// </summary>
        /// <param name="context"></param>
        /// <param name="logModel"></param>
        private void AnalysisTokenValue(ActionExecutedContext context, OperateLogModel logModel)
        {
            var token = HeadHelper.GetHead(context.HttpContext.Request, ParameterConstant.Token);
            var tokenValue = TokenHelper.Instance.GetTokenValue(token);
            if (tokenValue != null)
            {
                logModel.CompanyId = tokenValue.CompanyId.ToString();
                logModel.ProjectId = tokenValue.ProjectId.ToString();
                logModel.UserId = tokenValue.UserId.ToString();
                logModel.RoleId = tokenValue.RoleId.ToString();
            }
        }
    }
}
