﻿using System;
using System.Collections.Generic;
using System.Text;

namespace  Siger.WeComApi.Core.Domain.BigData.ResultData
{
    public class LocationYield
    {
        public int id { get; set; }
        /// <summary>
        /// 通道名称
        /// </summary>
        public int sectionID { get; set; }

        /// <summary>
        /// 设备id
        /// </summary>
        public int machineID { get; set; }

        /// <summary>
        /// 产量
        /// </summary>
        public int yield { get; set; }

        /// <summary>
        /// 产品名称
        /// </summary>
        public string productName { get; set; }

        /// <summary>
        /// 数据时间
        /// </summary>
        public DateTime dataTime { get; set; }
        /// <summary>
        /// 数据时间 （小时）
        /// </summary>
        public int hour { get; set; }
        /// <summary>
        /// 是否换型
        /// </summary>
        public int status { get; set; }
        public double cycletime { get; set; }
        public double subtraction { get; set; }
        public DateTime startTime { get; set; }
        public DateTime endTime { get; set; }
        public int type { get; set; }
        public string workOrderId { get; set; }
        /// <summary>
        /// 编辑人
        /// </summary>
        public int editor { get; set; }
        /// <summary>
        /// 编辑时间
        /// </summary>
        public int edit_time { get; set; }
    }

    public class LocationYields
    {
        public int id { get; set; }
        /// <summary>
        /// 工位ID
        /// </summary>
        public int sectionID { get; set; }

        /// <summary>
        /// 设备id
        /// </summary>
        public int machineID { get; set; }

        /// <summary>
        /// 产量
        /// </summary>
        public int yield { get; set; }

        /// <summary>
        /// 产品名称
        /// </summary>
        public string productName { get; set; }

        /// <summary>
        /// 数据时间
        /// </summary>
        public DateTime dataTime { get; set; }
        /// <summary>
        /// 数据时间 （小时）
        /// </summary>
        public int hour { get; set; }
        /// <summary>
        /// 是否换型
        /// </summary>
        public int status { get; set; }
        public double cycletime { get; set; }
        public double subtraction { get; set; }
        public DateTime startTime { get; set; }
        public DateTime endTime { get; set; }
        public int type { get; set; }
        public string workOrderId { get; set; }
    }

    public class PagedCollectionResult<T>
    {
        public IEnumerable<T> Data { get; private set; }

        public int Total { get; private set; }


        public PagedCollectionResult(IEnumerable<T> entities, long totalCount)
        {
            Data = entities;
            Total = int.Parse(totalCount.ToString());
        }
    }
    public class LocationYieldsType
    {
        public int type { get; set; }
    }
}
