﻿
using Siger.WeComApi.Common.Enums.Extensions;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Siger.WeComApi.Core.Domain.Data.Tpm
{
    public class RepairListForMTTR
    {
        public string date { get; set; }

        public string fault_content { get; set; }

        public string fault_description { get; set; }

        public int faultid { get; set; }

        public int faulttypeid { get; set; }

        public int id { get; set; }
        public string levelname { get; set; }
        public string name { get; set; }

        public string real_faultid_desc { get; set; }

        public string remark { get; set; }

        public string repair_process { get; set; }

        public decimal repairtime { get; set; }

        public string reporttime { get; set; }

        public string sparepart { get; set; }

        public string sparepartid { get; set; }

        public int createtime { get; set; }

        public int offlinestatus { get; set; }

        public int machineid { get; set; }

        public int checktime { get; set; }
        public int repairmid { get; set; }
        public int expection { get; set; }
        public string workorder { get; set; }
        public List<string> mids { get { return name.Split(',').ToList(); } }

        private List<Tuple<int, string>> spareparts { get; set; }

        /// <summary>
        /// 解析Sparepartid
        /// </summary>
        public void AnalysisSparepartid()
        {
            if (!string.IsNullOrWhiteSpace(sparepartid))
            {
                spareparts = new List<Tuple<int, string>>();
                var spars = sparepartid.Split(',');
                var sparInfos = new List<string>();
                foreach (var spar in spars)
                {
                    var sps = spar.Split('*');
                    if (sps.Length == 2 && !spareparts.Exists(x => x.Item1 == sps[0].ToInt()))
                    {
                        spareparts.Add(new Tuple<int, string>(sps[0].ToInt(), sps[1]));
                    }
                }
            }
        }

        public List<Tuple<int, string>> GetSpareparts()
        {
            if (spareparts == null)
            {
                AnalysisSparepartid();
            }
            return spareparts ?? new List<Tuple<int, string>>();
        }
    }
}
