﻿using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;

namespace Siger.WeComApi.Core.Dto.Request
{
    public class RequestAddRoute
    {
        public int productid { get; set; }

        public int group_id { get; set; }

        public IEnumerable<RouteInfo> routes { get; set; }
    }

    public class RequestUpdateRoute
    {
        public int id { get; set; }

        public string description { get; set; }

        public string hours { get; set; }

        public string prepare { get; set; }
    }

    public class RouteInfo
    {
        public string route_ordernumber { get; set; }

        public string machine_type { get; set; }

        [Required(ErrorMessage = "NameIsEmpty")]
        public string route_name { get; set; }

        public string description { get; set; }

        public string hours { get; set; }

        public string prepare { get; set; }
        /// <summary>
        /// 是否为并行工序
        /// </summary>
        public int parallelProcess { get; set; }

        public int standard_id { get; set; }
        /// <summary>
        /// 控制类型:1无限制 2精确控制
        /// </summary>
        public int control_type { get; set; } = 1;

        /// <summary>
        /// 流转类型  1手动 2自动
        /// </summary>
        public int transfer_type { get; set; }

        /// <summary>
        /// 工序类型 1自助 2外协 3辅助工序
        /// </summary>
        public int route_type { get; set; }

        /// <summary>
        /// 工艺过程
        /// </summary>
        public string craft_process { get; set; }

        /// <summary>
        /// 是否是默认版本 1是2否
        /// </summary>
        public int is_default { get; set; }
        public RouteInfo()
        {
            machine_type = "";
        }
    }
}
