﻿using Siger.Middlelayer.Repository.Repositories;
using Siger.WeComApi.Common.Enums;
using Siger.WeComApi.Core.Domain.Entity;
using Siger.WeComApi.Core.Repository;
using System;
using System.Linq;

namespace Siger.WeComApi.Repository.Repositories
{
    internal class SigerWeComCompanyRepository : ApiConfigRepositoryBase<siger_wecom_company>, ISigerWeComCompanyRepository
    {
        /// <summary>
        /// 主库,写操作
        /// </summary>
        protected new readonly BaseDataDbContext DbMaster;

        /// <summary>
        /// 从库,读操作
        /// </summary>
        protected new readonly BaseDataReadDbContext DbSlave;
        public SigerWeComCompanyRepository(BaseDataDbContext dbMaster, BaseDataReadDbContext dbSlave) : base(dbMaster, dbSlave)
        {
            this.DbMaster = dbMaster; this.DbSlave = dbSlave;
        }

        public siger_wecom_company GetSigerWeComCompany(string id,string corpid)
        {
            var companies = DbSlave.siger_wecom_company.Where(f => f.status == (int)RowState.Valid);
            if (companies != null && !string.IsNullOrEmpty(id))
            {
                companies = companies.Where(c => c.id == id);
            }
            if (companies != null && !string.IsNullOrEmpty(corpid))
            {
                companies = companies.Where(c => c.corpid == corpid);
            }
            return companies.FirstOrDefault();
        }

        public string AddSigerWeComCompany(siger_wecom_company siger_wecom_company)
        {
            siger_wecom_company dbWeComCompany = GetSigerWeComCompany("",siger_wecom_company.corpid);
            //判断该公司信息是否已存在于数据库
            if (dbWeComCompany != null && !string.IsNullOrEmpty(dbWeComCompany.corpid))
            {
                siger_wecom_company.id = dbWeComCompany.id;
                siger_wecom_company.createtime = dbWeComCompany.createtime;
                siger_wecom_company.status = dbWeComCompany.status;
                siger_wecom_company.updatetime = DateTime.Now;
                DbMaster.siger_wecom_company.Update(siger_wecom_company);
                DbMaster.SaveChanges();
            }
            else
            {
                siger_wecom_company.id =  Guid.NewGuid().ToString();
                siger_wecom_company.createtime = DateTime.Now;
                siger_wecom_company.status = (int)RowState.Valid;
                DbMaster.siger_wecom_company.Add(siger_wecom_company);
                DbMaster.SaveChanges();
            }
            return siger_wecom_company.corpid;
        }

        public siger_wecom_company CheckSigerSelfWeComCompany(string sigerCorpID) 
        {
            siger_wecom_company sigerWeComCompany = GetSigerWeComCompany("", sigerCorpID);
            //判断西格数据信息是否已存在于数据库
            if (sigerWeComCompany != null && !string.IsNullOrEmpty(sigerWeComCompany.corpid))
            {
                return sigerWeComCompany;
            }
            else
            {
                siger_wecom_company sigerWecom = new siger_wecom_company();
                sigerWecom.id = Guid.NewGuid().ToString();
                sigerWecom.corpid = sigerCorpID;
                sigerWecom.permanent_code = "";
                sigerWecom.corp_name = "西格数据";
                sigerWecom.corp_full_name = "西格数据";
                sigerWecom.corp_type = "verified";
                sigerWecom.corp_round_logo_url = "http://p.qpic.cn/pic_wework/1061759103/f4f236fcca1232e5fdfd669ad3844eb1cab610e7dc6a3a1e/0";
                sigerWecom.corp_square_logo_url = "https://p.qlogo.cn/bizmail/WcOicvn7DDmYbS4dd28ufiaWv4xoiaXZAMPcXLL94MeoTbWCbgunaicSow/0";
                sigerWecom.corp_user_max = 200;
                sigerWecom.corp_wxqrcode = "https://wework.qpic.cn/wwpic/793742_GjSsh6T-Rj-xsA9_1651193581/0";
                sigerWecom.subject_type = 1;
                sigerWecom.corp_scale = "101-200人";
                sigerWecom.corp_industry = "IT服务";
                sigerWecom.corp_industry = "计算机软件/硬件/信息服务";

                sigerWecom.createtime = DateTime.Now;
                sigerWecom.status = (int)RowState.Valid;
                DbMaster.siger_wecom_company.Add(sigerWecom);
                DbMaster.SaveChanges();
                return sigerWecom;
            }

        }

    }
}
