﻿

namespace Siger.WeComApi.Common.ExcelImport
{
    public class UserWorkTimeList : ImportBase
    {
        [ExcelColumn("序号")]
        public int No { get; set; }

        [ExcelColumn("工号")]
        public string workcode { get; set; }

        [ExcelColumn("姓名")]
        public string username { get; set; }

        [ExcelColumn("班组")]
        public string groupname { get; set; }

        [ExcelColumn("部门")]
        public string departname { get; set; }

        [ExcelColumn("岗位")]
        public string stationname { get; set; }

        [ExcelColumn("作业工时(H)")]
        public double worktime { get; set; }

        [ExcelColumn("损失工时(H)")]
        public double losstime { get; set; }

        [ExcelColumn("实际生产工时(H)")]
        public double producttime { get; set; }

        [ExcelColumn("有效产出工时(H)")]
        public double efficiencytime { get; set; }

        [ExcelColumn("作业效率")]
        public string workefficiency { get; set; }
    }

    public class WorkTimeCount : ImportBase
    {
        [ExcelColumn("作业工时(H)")]
        public double worktime { get; set; }

        [ExcelColumn("损失工时(H)")]
        public double losstime { get; set; }

        [ExcelColumn("实际生产工时(H)")]
        public double producttime { get; set; }

        [ExcelColumn("有效产出工时(H)")]
        public double efficiencytime { get; set; }

        [ExcelColumn("作业效率")]
        public string workefficiency { get; set; }
    }

    public class DateWorkTimeCount : WorkTimeCount
    {
        [ExcelColumn("序号")]
        public int No { get; set; }

        [ExcelColumn("日期")]
        public string date { get; set; }
    }

    public class GroupWorkTimeCount : WorkTimeCount
    {
        [ExcelColumn("序号")]
        public int No { get; set; }

        [ExcelColumn("班组")]
        public string groupname { get; set; }
    }

    public class UserWorkTimeCount : WorkTimeCount
    {
        [ExcelColumn("序号")]
        public int No { get; set; }

        [ExcelColumn("姓名")]
        public string username { get; set; }
    }

    public class SignRecordList : ImportBase
    {
        [ExcelColumn("序号")]
        public int No { get; set; }

        [ExcelColumn("设备位置")]
        public string location { get; set; }

        [ExcelColumn("工号")]
        public string workcode { get; set; }

        [ExcelColumn("姓名")]
        public string username { get; set; }

        [ExcelColumn("部门")]
        public string departname { get; set; }

        [ExcelColumn("岗位")]
        public string stationname { get; set; }

        [ExcelColumn("班组")]
        public string groupname { get; set; }

        [ExcelColumn("上工时间")]
        public string startworktime { get; set; }

        [ExcelColumn("下班时间")]
        public string endworktime { get; set; }

        [ExcelColumn("作业工时(H)")]
        public double totaltime { get; set; }        
    }
}
