﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Siger.WeComApi.Common.Enums.Extensions
{
    public static class ObjectExtensions
    {
        public static string ToValidParameter(this string value)
        {
            if (string.IsNullOrWhiteSpace(value))
            {
                return string.Empty;
            }
            if (value == "0")
            {
                return string.Empty;
            }
            return value;
        }

        public static int ToInt(this string value)
        {
            if (string.IsNullOrWhiteSpace(value))
            {
                return 0;
            }

            var success = int.TryParse(value, out var result);
            return success ? result : 0;
        }

        public static string ToStr(this object value)
        {
            if (null == value)
            {
                return string.Empty;
            }
            if (string.IsNullOrWhiteSpace(value.ToString()))
            {
                return string.Empty;
            }
            
            return value.ToString();
        }

        public static double ToDouble(this string value)
        {
            if (string.IsNullOrWhiteSpace(value))
            {
                return 0;
            }

            var success = double.TryParse(value, out var result);
            return success ? result : 0;
        }

        public static float ToFloat(this string value)
        {
            if (string.IsNullOrWhiteSpace(value))
            {
                return 0;
            }

            var success = float.TryParse(value, out var result);
            return success ? result : 0;
        }

        public static DateTime ToDateTime(this string value)
        {
            if (string.IsNullOrWhiteSpace(value))
            {
                return DateTime.MinValue;
            }

            var success = DateTime.TryParse(value, out var result);
            return success ? result : DateTime.MinValue;
        }

        /// <summary>
        /// 
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="value">default value when cast failed</param>
        /// <returns></returns>
        public static T CastTo<T>(this object value)
        {
            object result;
            Type type = typeof(T);
            try
            {
                if (type.IsEnum)
                {
                    result = Enum.Parse(type, value.ToString());
                }
                else if (type == typeof(Guid))
                {
                    result = Guid.Parse(value.ToString());
                }
                else
                {
                    result = Convert.ChangeType(value, type);
                }
            }
            catch
            {
                result = default(T);
            }

            return (T)result;
        }

        /// <summary>
        /// 
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="value"></param>
        /// <param name="defaultValue">default value when cast failed</param>
        /// <returns></returns>
        public static T CastTo<T>(this object value, T defaultValue)
        {
            object result;
            Type type = typeof(T);
            try
            {
                result = type.IsEnum ? Enum.Parse(type, value.ToString()) : Convert.ChangeType(value, type);
            }
            catch
            {
                result = defaultValue;
            }
            return (T)result;
        }

        /// <summary>
        /// value1 is equal value ignore case
        /// </summary>
        /// <param name="value1"></param>
        /// <param name="value2"></param>
        /// <returns></returns>
        public static bool IsEqual(this string value1, string value2)
        {
            return string.Equals(value1, value2, StringComparison.CurrentCultureIgnoreCase);
        }

        public static double FormatDouble(this double value)
        {
            if (value > 100)
            {
                return 100;
            }

            if (value < 0)
            {
                return 0;
            }

            return Math.Round(value, 1);
        }
    }
}
