﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Siger.WeComApi.Core.Domain.Data.Tpm
{
    public class GetListPlanItem : EntityBase
    {
        public int id { get; set; }

        #region planitem的字段

        /// <summary>
        /// 1->设备类型共有；2->某设备独有
        /// </summary>
        public int type { get; set; } 

        /// <summary>
        /// _project_machine_type.id
        /// </summary>
        public int typeid { get; set; } 

        /// <summary>
        /// _project_machine.id
        /// </summary>
        public int machineid { get; set; } 

        /// <summary>
        /// 维护检查的内容
        /// </summary>
        public string content { get; set; } 

        /// <summary>
        /// 1->勾选确定型；2->数值记录型
        /// </summary>
        public int value_type { get; set; } 

        /// <summary>
        /// 模式 1->AM(自主执行)；2->PM
        /// </summary>
        public int mode { get; set; } 

        /// <summary>
        /// 数值单位
        /// </summary>
        public string unit { get; set; } 

        /// <summary>
        /// 上限
        /// </summary>
        public string up_limit { get; set; } 

        /// <summary>
        /// 下限
        /// </summary>
        public string lower_limit { get; set; } 

        /// <summary>
        /// 严重度等级1->高；2->中；3->低
        /// </summary>
        public int severity_level { get; set; } 

        /// <summary>
        /// 对应故障失效模式
        /// </summary>
        public string failure_mode { get; set; } 

        /// <summary>
        /// 执行指导书
        /// </summary>
        public string work_instruction_url { get; set; } 

        /// <summary>
        /// 结果样板
        /// </summary>
        public string result_demo_url { get; set; } 

        /// <summary>
        /// 计划用时（分钟）
        /// </summary>
        public int standard_time { get; set; } 

        /// <summary>
        /// 执行周期（天）
        /// </summary>
        public int instruction_cycle { get; set; } 

        /// <summary>
        /// 创建人
        /// </summary>
        public int create_mid { get; set; } 

        /// <summary>
        /// 创建时间
        /// </summary>
        public int create_time { get; set; } 

        /// <summary>
        /// 备注
        /// </summary>
        public string remark { get; set; } 

        /// <summary>
        /// 执行指导书name
        /// </summary>
        public string work_instruction_name { get; set; }

        /// <summary>
        /// 是否自动更新计划  0:否 1:是
        /// </summary>
        public int autoupdate { get; set; } = 0;

        #endregion

        #region plan的字段
        /// <summary>
        /// _project_plan_item.id
        /// </summary>
        public int itemid { get; set; } 

        /// <summary>
        /// 第一次执行时间
        /// </summary>
        public string first_instruction_time { get; set; } 

        /// <summary>
        /// 执行人
        /// </summary>
        public string instruction_mid { get; set; } 

        /// <summary>
        /// 
        /// </summary>
        public int count { get; set; } 

        /// <summary>
        /// 执行日期范围，默认1一直执行(1年)，2自定义执行日期范围
        /// </summary>
        public int date_rang { get; set; } 

        /// <summary>
        /// 
        /// </summary>
        public int endtime { get; set; } 

        /// <summary>
        /// 
        /// </summary>
        public int starttime { get; set; }

        #endregion

        //  tpm/plan/GetonePlan 接口返回参数
        public string first_instruction_time_date { get; set; }
        public string date_rang_str { get; set; }

        //  tpm/plan/GetonePlanTimeUser 接口返回参数
        public List<IdText> users { get; set; } = new List<IdText>();
        public string departid { get; set; }
        public List<string> user { get; set; } = new List<string>();


        /// <summary>
        /// 维护工具
        /// </summary>
        public string maintain_tool { get; set; }

        /// <summary>
        /// 维护备件
        /// </summary>
        public string maintain_sparepart { get; set; }

        public string hit_item { get; set; }

        public string maintain_method { get; set; }

        public int faulttype { get; set; }
    }

    public class IdText
    {
        public int id { get; set; }

        public string text { get; set; }
    }
}
