﻿using System.ComponentModel.DataAnnotations;

namespace Siger.WeComApi.Core.Dto.Request
{
    public class RequestAddReportConfig
    {
        [Required(ErrorMessage = "NameIsEmpty")]
        public string name { get; set; }

        /// <summary>
        /// 天/周/月
        /// </summary>
        public int cycle { get; set; }

        /// <summary>
        /// 每隔几天/周几/月初或者月底
        /// </summary>
        public string day_interval { get; set; } = string.Empty;

        public string first_date { get; set; } = string.Empty;

        public string send_time { get; set; } = string.Empty;

        public string remark { get; set; } = string.Empty;

        public int template_id { get; set; } = 0;

        public string userIds { get; set; } = string.Empty;

        public string sectionIds { get; set; } = string.Empty;

        public string productId { get; set; } = string.Empty;
    }

    public class RequestUpdateReportConfig : RequestAddReportConfig
    {
        public int id { get; set; }
    }
}
