﻿using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Siger.WeComApi.Common.cache;
using Siger.CommonUtil;
using Siger.Middlelayer.Redis.RedisEntities;

namespace Siger.Middlelayer.Redis
{
    public partial class RedisCache
    {
        private static RedisCache _cacheString;
        public static RedisCache Instance = _cacheString ?? (_cacheString = new RedisCache());

        public const string DbNameConfigHash = "DBNameConfig";
        public async Task<DbNameConfig> GetDbName(int cid, int pid)
        {
            var key = $"{cid}_{pid}";

            var config = await CacheUtility.Instance.GetHashAsync(DbNameConfigHash, key);
            //int hashcode = Client.GetHashCode();
            //Log.Logger.WriteLineInfo("RedisCache-Client-hashcode:" + hashcode);
            if (!string.IsNullOrWhiteSpace(config))
            {
                return JsonHelper.DeserializeObj<DbNameConfig>(config);
            }
            return null;
        }

        public async Task<IEnumerable<DbNameConfig>> GetDbNameConfigs()
        {
            var dbConfigs = new List<DbNameConfig>();
            var configs = await CacheUtility.Instance.HGetAllAsync(DbNameConfigHash);
            foreach (var config in configs)
            {
                dbConfigs.Add(JsonHelper.DeserializeObj<DbNameConfig>(config.Value));
            }

            return dbConfigs.OrderBy(q => q.Cid);
        }

        public async Task AddDbNameConfig(DbNameConfig config)
        {
            var key = $"{config.Cid}_{config.Pid}";

            var json = JsonHelper.SerializeObj(config);

            await CacheUtility.Instance.SetHashAsync(DbNameConfigHash, key, json);
        }

        public void DeleteDbNameConfig(string key)
        {
            CacheUtility.Instance.DeleteHost(DbNameConfigHash, key);
        }
    }
}
